package com.artfess.device.monitor.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.monitor.dao.DeviceDataSignboaerdDao;
import com.artfess.device.monitor.manager.DeviceDataSignboaerdManager;
import com.artfess.device.monitor.model.DeviceDataSignboaerd;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

/**
 * 实时监控-标识牌监控（DEVICE_DATA_SIGNBOAERD） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2022-07-26
 */
@Service
public class DeviceDataSignboaerdManagerImpl extends BaseManagerImpl<DeviceDataSignboaerdDao, DeviceDataSignboaerd> implements DeviceDataSignboaerdManager {


    @Override
    public CommonResult findByDeviceId(String productType, QueryFilter<DeviceDataSignboaerd> queryFilter) {
        Map<String, Object> data = Maps.newHashMap();
        data.put("productType", productType);

        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceDataSignboaerd> result = baseMapper.findByDeviceId(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));

        data.put("data", new PageList<DeviceDataSignboaerd>(result));
        return CommonResult.success(data, "查询成功");
    }

    @Override
    @Transactional(readOnly=true)
    public PageList<DeviceDataSignboaerd> query(QueryFilter<DeviceDataSignboaerd> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class<DeviceDataSignboaerd> currentModelClass = currentModelClass();
        IPage<DeviceDataSignboaerd> result = baseMapper.findByDeviceId(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass));
        return new PageList<DeviceDataSignboaerd>(result);
    }
}
