package com.artfess.device.base.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author 黎沐华
 * @date 2022/8/11 12:48
 */
@Data
@ApiModel("设备安全统计VO")
public class StatisticsVo {

    @ApiModelProperty("类型")
    private String type;

    @ApiModelProperty("状态")
    private String status;

    @ApiModelProperty("月份，用于各月份统计")
    private String month;

    @ApiModelProperty("计数")
    private Integer count;

    @ApiModelProperty("设备所属区域")
    private String area;

    @ApiModelProperty("时间")
    private String time;

    @ApiModelProperty("分级数据")
    private List<StatisticsVo> data;

    public StatisticsVo() {
    }

    public StatisticsVo(String type) {
        this.type = type;
    }

    public StatisticsVo(String status, Integer count) {
        this.status = status;
        this.count = count;
    }

    public StatisticsVo(String time, List<StatisticsVo> data) {
        this.time = time;
        this.data = data;
    }
}
