package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceMetadataPropertiesDao;
import com.artfess.device.base.manager.DeviceMetadataPropertiesManager;
import com.artfess.device.base.model.DeviceMetadataProperties;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 产品物模型属性 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Service
public class DeviceMetadataPropertiesManagerImpl extends BaseManagerImpl<DeviceMetadataPropertiesDao, DeviceMetadataProperties> implements DeviceMetadataPropertiesManager {


    @Override
    public List<DeviceMetadataProperties> findAll(DeviceMetadataProperties entity) {
        QueryWrapper<DeviceMetadataProperties> queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(entity.getCode())){
            queryWrapper.like("code_", entity.getCode());
        }

        if(StringUtils.isNotBlank(entity.getName())){
            queryWrapper.like("name_", entity.getName());
        }

        if(StringUtils.isNotBlank(entity.getProductId())){
            queryWrapper.eq("product_id_", entity.getProductId());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByAsc("sn_");
        return this.baseMapper.selectList(queryWrapper);
    }

    @Override
    public void vaild(DeviceMetadataProperties t) {
        QueryWrapper<DeviceMetadataProperties> queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(t.getId())) {
            queryWrapper.ne("id_", t.getId());
        }
        queryWrapper.eq("code_", t.getCode()).eq("product_id_",t.getProductId());
        List<DeviceMetadataProperties> properties = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(properties)) {
            throw new IllegalArgumentException("属性标识已重复，请重新输入");
        }
        queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(t.getId())) {
            queryWrapper.ne("id_", t.getId());
        }
        queryWrapper.eq("name_", t.getName()).eq("product_id_",t.getProductId());

        properties = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(properties)) {
            throw new IllegalArgumentException("属性名称已重复，请重新输入");
        }
    }
}
