package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.model.DeviceVideoBase;
import com.artfess.device.base.model.DeviceVideoPoint;
import com.artfess.device.base.model.DeviceVideoZone;
import com.artfess.device.base.vo.CollectVo;
import com.artfess.device.base.vo.HaiKangRequest;

import java.util.List;

/**
 * 视频目录基础信息表（DEVICE_VIDEO_BASE） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-19
 */
public interface DeviceVideoBaseManager extends BaseManager<DeviceVideoBase> {

    /**
    * 获取海康视频播放URL
    * @param code 视频编码
    * @param module  播放协议（rtsp,rtmp,hls,ws,wss）
    * @Return: java.lang.String
    * @Author: chens
    * @Date: 2022/11/10 10:02
    */
    String hkPreviewURLs(String code, String module);

    PageList<DeviceVideoPoint> findByPage(QueryFilter<DeviceVideoBase> queryFilter);

    List<DeviceVideoZone> getTree(CollectVo t);

    List<DeviceVideoBase> getCataLogBase();

    List<DeviceVideoPoint> findByZoneCode(QueryFilter<DeviceVideoBase> queryFilter);

    void asycCataLog();

    void asycCataLogZone(HaiKangRequest haiKangRequest);

    void asycZoneRes(HaiKangRequest haiKangRequest);

    List<DeviceVideoZone> getAllTree(CollectVo t);
}
