package com.artfess.device.base.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.model.CommonResult;
import com.artfess.device.base.manager.DeviceGroupInfoManager;
import com.artfess.device.base.model.DeviceGroupInfo;
import com.artfess.device.base.vo.DeviceGroupVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 设备分组信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Slf4j
@RestController
@Api(tags = "设施设备-设备分组管理")
@RequestMapping("/device/group/info/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceGroupInfoController extends BaseController<DeviceGroupInfoManager, DeviceGroupInfo> {

    @PostMapping("/bindDevice")
    @ApiOperation("关联设备")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.ADD, description = "关联设备")
    public CommonResult<String> bindDevice(@ApiParam(name="model", value="实体信息") @RequestBody DeviceGroupVo t) {
        log.info("关联设备请求参数:{}", JSON.toJSONString(t));
        baseService.bindDevice(t);
        return new CommonResult<>();
    }

    @PostMapping("/getDeviceList")
    @ApiOperation("获取已关联设备")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.QUERY, description = "获取已关联设备")
    public CommonResult<String> getDeviceList(@ApiParam(name="model", value="实体信息") @RequestBody DeviceGroupVo t) {
        log.info("获取已关联设备请求参数:{}", JSON.toJSONString(t));
        DeviceGroupVo base = baseService.getDeviceList(t);
        return CommonResult.success(base, "查询成功");
    }

}
