package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 绩效考核-考核情况（DEVICE_APPRAISE_INFO）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author Limuhua
 * @since 2022-08-02
 */
@Data
@TableName("device_appraise_info")
@ApiModel(value="DeviceAppraiseInfo对象", description="绩效考核-考核情况（DEVICE_APPRAISE_INFO）")
public class AppraiseInfo extends AutoFillModel<AppraiseInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定考核情况id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请填写考核配置ID",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核配置ID")
    @TableField(value = "base_id_")
    private String baseId;

    @NotBlank(message = "请填写考核人员",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核人员")
    @TableField("assess_user_")
    private String assessUser;

    @NotNull(message = "请填写考核日期",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核日期")
    @TableField("assess_date_")
    private LocalDate assessDate;

    @NotBlank(message = "请填写考核方式",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核方式【字典】（1：单位考核，2：合同考核）")
    @TableField("assess_type_")
    private String assessType;

    @NotBlank(message = "请填写被考核者",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "被考核者（可能是单位，可能是合同）")
    @TableField("reference_")
    private String reference;

    @ApiModelProperty(value = "考核得分")
    @TableField("result_")
    private BigDecimal result;

    @ApiModelProperty(value = "是否结算，1已结算，0未结算")
    @TableField("CLOSE_STATUS_")
    private String closStatus;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @ApiModelProperty("详情数据")
    @TableField(exist = false)
    @NotNull(message = "详细数据不能为null",groups = {AddGroup.class,UpdateGroup.class})
    private List<AppraiseDetails> detailsList;

    @ApiModelProperty(value = "考核标题")
    @TableField(exist = false)
    private String assessTitle;

    @ApiModelProperty(value = "考核年度")
    @TableField(exist = false)
    private Integer assessYear;

}
