/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceProductWarnConfDao;
import com.artfess.device.base.dao.DeviceProductWarnConfDetailsDao;
import com.artfess.device.base.manager.DeviceProductWarnConfManager;
import com.artfess.device.base.model.DeviceProductWarnConf;
import com.artfess.device.base.model.DeviceProductWarnConfDetails;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DeviceProductWarnConfManagerImpl
extends BaseManagerImpl<DeviceProductWarnConfDao, DeviceProductWarnConf>
implements DeviceProductWarnConfManager {
    @Resource
    private DeviceProductWarnConfDetailsDao deviceProductWarnConfDetailsDao;

    @Override
    public DeviceProductWarnConf findById(String id) {
        DeviceProductWarnConf deviceProductWarnConf = (DeviceProductWarnConf)((Object)((DeviceProductWarnConfDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (null == deviceProductWarnConf) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"product_warn_conf_id_", (Object)id);
        List deviceProductWarnConfDetails = this.deviceProductWarnConfDetailsDao.selectList((Wrapper)queryWrapper);
        deviceProductWarnConf.setList(deviceProductWarnConfDetails);
        return deviceProductWarnConf;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(DeviceProductWarnConf t) {
        this.vaild(t);
        int i = ((DeviceProductWarnConfDao)this.baseMapper).updateById((Object)t);
        if (i > 0) {
            this.processDetails(t.getId(), t.getList());
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(DeviceProductWarnConf t) {
        this.vaild(t);
        int i = ((DeviceProductWarnConfDao)this.baseMapper).insert((Object)t);
        if (i > 0) {
            this.processDetails(t.getId(), t.getList());
            return true;
        }
        return false;
    }

    @Override
    public List<DeviceProductWarnConf> findByParams(DeviceProductWarnConf conf) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)conf.getProductId())) {
            queryWrapper.like((Object)"PRODUCT_ID_", (Object)conf.getProductId());
        }
        if (StringUtils.isNotBlank((CharSequence)conf.getWarnName())) {
            queryWrapper.like((Object)"WARN_NAME_", (Object)conf.getWarnName());
        }
        queryWrapper.orderByDesc((Object)"CREATE_TIME_");
        return ((DeviceProductWarnConfDao)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    private void processDetails(String id, List<DeviceProductWarnConfDetails> list) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"product_warn_conf_id_", (Object)id);
        this.deviceProductWarnConfDetailsDao.delete((Wrapper)queryWrapper);
        list.forEach(details -> {
            details.setProductWarnConfId(id);
            this.deviceProductWarnConfDetailsDao.insert(details);
        });
    }

    public void vaild(DeviceProductWarnConf t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)t.getId())) {
            queryWrapper.ne((Object)"id_", (Object)t.getId());
        }
        ((QueryWrapper)queryWrapper.eq((Object)"warn_name_", (Object)t.getWarnName())).eq((Object)"product_id_", (Object)t.getProductId());
        List properties = ((DeviceProductWarnConfDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)properties)) {
            throw new IllegalArgumentException("\u544a\u8b66\u540d\u79f0\u5df2\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
    }
}

