/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.controller;

import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.DeviceProductTypeManager;
import com.artfess.device.base.model.DeviceProductType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bbe\u65bd\u8bbe\u5907-\u4ea7\u54c1\u5206\u7c7b\u7ba1\u7406"})
@RequestMapping(value={"/device/product/type/"})
@ApiGroup(group={"device_biz"})
public class DeviceProductTypeController
extends BaseController<DeviceProductTypeManager, DeviceProductType> {
    private static final Logger log = LoggerFactory.getLogger(DeviceProductTypeController.class);

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) DeviceProductType t) {
        String id = ((DeviceProductTypeManager)this.baseService).insertTree(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) DeviceProductType t) {
        String id = ((DeviceProductTypeManager)this.baseService).updateProductType(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/getTree"})
    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1\u5206\u7c7b\u4e0b\u62c9\u6811")
    @PowerLogInfo(logType=LogType.BIZ, operaionType=OperationType.QUERY, description="\u83b7\u53d6\u4ea7\u54c1\u5206\u7c7b\u4e0b\u62c9\u6811")
    public CommonResult<String> getTree(@ApiParam(name="model", value="\u83b7\u53d6\u4ea7\u54c1\u5206\u7c7b\u4e0b\u62c9\u6811") @RequestBody DeviceProductType entity) {
        log.info("\u83b7\u53d6\u4ea7\u54c1\u5206\u7c7b\u4e0b\u62c9\u6811\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)((Object)entity)));
        List<DeviceProductType> list = ((DeviceProductTypeManager)this.baseService).getTree(entity);
        return CommonResult.success(list, null);
    }
}

