/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.DeviceProductInfoManager;
import com.artfess.device.base.model.DeviceProductInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bbe\u65bd\u8bbe\u5907-\u4ea7\u54c1\u7ba1\u7406"})
@RequestMapping(value={"/device/product/info/"})
@ApiGroup(group={"device_biz"})
public class DeviceProductInfoController
extends BaseController<DeviceProductInfoManager, DeviceProductInfo> {
    private static final Logger log = LoggerFactory.getLogger(DeviceProductInfoController.class);

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) DeviceProductInfo t) {
        String id = ((DeviceProductInfoManager)this.baseService).createInfo(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) DeviceProductInfo t) {
        String id = ((DeviceProductInfoManager)this.baseService).updateInfo(t);
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/findAll"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1\u5217\u8868\uff08\u4e0d\u5206\u9875\uff09")
    public List<DeviceProductInfo> findAll(@ApiParam(name="model", value="\u67e5\u8be2\u6761\u4ef6") @RequestBody DeviceProductInfo productInfo) {
        return ((DeviceProductInfoManager)this.baseService).findAll(productInfo);
    }
}

