/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.third.vo;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class DingCallbackCrypto {
    private static final Charset CHARSET = Charset.forName("utf-8");
    private static final Base64 base64 = new Base64();
    private byte[] aesKey;
    private String token;
    private String corpId;
    private static final Integer AES_ENCODE_KEY_LENGTH = 43;
    private static final Integer RANDOM_LENGTH = 16;

    public DingCallbackCrypto(String token, String encodingAesKey, String corpId) throws DingTalkEncryptException {
        if (null == encodingAesKey || encodingAesKey.length() != AES_ENCODE_KEY_LENGTH.intValue()) {
            throw new DingTalkEncryptException(900004);
        }
        this.token = token;
        this.corpId = corpId;
        this.aesKey = Base64.decodeBase64((String)(encodingAesKey + "="));
    }

    public Map<String, String> getEncryptedMap(String plaintext) throws DingTalkEncryptException {
        return this.getEncryptedMap(plaintext, System.currentTimeMillis(), Utils.getRandomStr(16));
    }

    public Map<String, String> getEncryptedMap(String plaintext, Long timeStamp, String nonce) throws DingTalkEncryptException {
        if (null == plaintext) {
            throw new DingTalkEncryptException(900001);
        }
        if (null == timeStamp) {
            throw new DingTalkEncryptException(900002);
        }
        if (null == nonce) {
            throw new DingTalkEncryptException(900003);
        }
        String encrypt = this.encrypt(Utils.getRandomStr(RANDOM_LENGTH), plaintext);
        String signature = this.getSignature(this.token, String.valueOf(timeStamp), nonce, encrypt);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("msg_signature", signature);
        resultMap.put("encrypt", encrypt);
        resultMap.put("timeStamp", String.valueOf(timeStamp));
        resultMap.put("nonce", nonce);
        return resultMap;
    }

    public String getDecryptMsg(String msgSignature, String timeStamp, String nonce, String encryptMsg) throws DingTalkEncryptException {
        String signature = this.getSignature(this.token, timeStamp, nonce, encryptMsg);
        if (!signature.equals(msgSignature)) {
            throw new DingTalkEncryptException(900006);
        }
        String result = this.decrypt(encryptMsg);
        return result;
    }

    private String encrypt(String random, String plaintext) throws DingTalkEncryptException {
        try {
            byte[] randomBytes = random.getBytes(CHARSET);
            byte[] plainTextBytes = plaintext.getBytes(CHARSET);
            byte[] lengthByte = Utils.int2Bytes(plainTextBytes.length);
            byte[] corpidBytes = this.corpId.getBytes(CHARSET);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            byteStream.write(randomBytes);
            byteStream.write(lengthByte);
            byteStream.write(plainTextBytes);
            byteStream.write(corpidBytes);
            byte[] padBytes = PKCS7Padding.getPaddingBytes(byteStream.size());
            byteStream.write(padBytes);
            byte[] unencrypted = byteStream.toByteArray();
            byteStream.close();
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(this.aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            byte[] encrypted = cipher.doFinal(unencrypted);
            String result = base64.encodeToString(encrypted);
            return result;
        }
        catch (Exception e) {
            throw new DingTalkEncryptException(900007);
        }
    }

    private String decrypt(String text) throws DingTalkEncryptException {
        String fromCorpid;
        String plainText;
        byte[] originalArr;
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(this.aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(this.aesKey, 0, 16));
            cipher.init(2, (Key)keySpec, iv);
            byte[] encrypted = Base64.decodeBase64((String)text);
            originalArr = cipher.doFinal(encrypted);
        }
        catch (Exception e) {
            throw new DingTalkEncryptException(900008);
        }
        try {
            byte[] bytes = PKCS7Padding.removePaddingBytes(originalArr);
            byte[] networkOrder = Arrays.copyOfRange(bytes, 16, 20);
            int plainTextLegth = Utils.bytes2int(networkOrder);
            plainText = new String(Arrays.copyOfRange(bytes, 20, 20 + plainTextLegth), CHARSET);
            fromCorpid = new String(Arrays.copyOfRange(bytes, 20 + plainTextLegth, bytes.length), CHARSET);
        }
        catch (Exception e) {
            throw new DingTalkEncryptException(900009);
        }
        if (!fromCorpid.equals(this.corpId)) {
            throw new DingTalkEncryptException(900010);
        }
        return plainText;
    }

    public String getSignature(String token, String timestamp, String nonce, String encrypt) throws DingTalkEncryptException {
        try {
            Object[] array = new String[]{token, timestamp, nonce, encrypt};
            Arrays.sort(array);
            System.out.println(JSON.toJSONString((Object)array));
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 4; ++i) {
                sb.append((String)array[i]);
            }
            String str = sb.toString();
            System.out.println(str);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(str.getBytes());
            byte[] digest = md.digest();
            StringBuffer hexstr = new StringBuffer();
            String shaHex = "";
            for (int i = 0; i < digest.length; ++i) {
                shaHex = Integer.toHexString(digest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexstr.append(0);
                }
                hexstr.append(shaHex);
            }
            return hexstr.toString();
        }
        catch (Exception e) {
            throw new DingTalkEncryptException(900006);
        }
    }

    private static void RemoveCryptographyRestrictions() throws Exception {
        Class<?> jceSecurity = DingCallbackCrypto.getClazz("javax.crypto.JceSecurity");
        Class<?> cryptoPermissions = DingCallbackCrypto.getClazz("javax.crypto.CryptoPermissions");
        Class<?> cryptoAllPermission = DingCallbackCrypto.getClazz("javax.crypto.CryptoAllPermission");
        if (jceSecurity != null) {
            DingCallbackCrypto.setFinalStaticValue(jceSecurity, "isRestricted", false);
            PermissionCollection defaultPolicy = DingCallbackCrypto.getFieldValue(jceSecurity, "defaultPolicy", null, PermissionCollection.class);
            if (cryptoPermissions != null) {
                Map map = DingCallbackCrypto.getFieldValue(cryptoPermissions, "perms", defaultPolicy, Map.class);
                map.clear();
            }
            if (cryptoAllPermission != null) {
                Permission permission = DingCallbackCrypto.getFieldValue(cryptoAllPermission, "INSTANCE", null, Permission.class);
                defaultPolicy.add(permission);
            }
        }
    }

    private static Class<?> getClazz(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    private static void setFinalStaticValue(Class<?> srcClazz, String fieldName, Object newValue) throws Exception {
        Field field = srcClazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }

    private static <T> T getFieldValue(Class<?> srcClazz, String fieldName, Object owner, Class<T> dstClazz) throws Exception {
        Field field = srcClazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return dstClazz.cast(field.get(owner));
    }

    static {
        try {
            Security.setProperty("crypto.policy", "limited");
            DingCallbackCrypto.RemoveCryptographyRestrictions();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class DingTalkEncryptException
    extends Exception {
        public static final int SUCCESS = 0;
        public static final int ENCRYPTION_PLAINTEXT_ILLEGAL = 900001;
        public static final int ENCRYPTION_TIMESTAMP_ILLEGAL = 900002;
        public static final int ENCRYPTION_NONCE_ILLEGAL = 900003;
        public static final int AES_KEY_ILLEGAL = 900004;
        public static final int SIGNATURE_NOT_MATCH = 900005;
        public static final int COMPUTE_SIGNATURE_ERROR = 900006;
        public static final int COMPUTE_ENCRYPT_TEXT_ERROR = 900007;
        public static final int COMPUTE_DECRYPT_TEXT_ERROR = 900008;
        public static final int COMPUTE_DECRYPT_TEXT_LENGTH_ERROR = 900009;
        public static final int COMPUTE_DECRYPT_TEXT_CORPID_ERROR = 900010;
        private static Map<Integer, String> msgMap = new HashMap<Integer, String>();
        private Integer code;

        public Integer getCode() {
            return this.code;
        }

        public DingTalkEncryptException(Integer exceptionCode) {
            super(msgMap.get(exceptionCode));
            this.code = exceptionCode;
        }

        static {
            msgMap.put(0, "\u6210\u529f");
            msgMap.put(900001, "\u52a0\u5bc6\u660e\u6587\u6587\u672c\u975e\u6cd5");
            msgMap.put(900002, "\u52a0\u5bc6\u65f6\u95f4\u6233\u53c2\u6570\u975e\u6cd5");
            msgMap.put(900003, "\u52a0\u5bc6\u968f\u673a\u5b57\u7b26\u4e32\u53c2\u6570\u975e\u6cd5");
            msgMap.put(900005, "\u7b7e\u540d\u4e0d\u5339\u914d");
            msgMap.put(900006, "\u7b7e\u540d\u8ba1\u7b97\u5931\u8d25");
            msgMap.put(900004, "\u4e0d\u5408\u6cd5\u7684aes key");
            msgMap.put(900007, "\u8ba1\u7b97\u52a0\u5bc6\u6587\u5b57\u9519\u8bef");
            msgMap.put(900008, "\u8ba1\u7b97\u89e3\u5bc6\u6587\u5b57\u9519\u8bef");
            msgMap.put(900009, "\u8ba1\u7b97\u89e3\u5bc6\u6587\u5b57\u957f\u5ea6\u4e0d\u5339\u914d");
            msgMap.put(900010, "\u8ba1\u7b97\u89e3\u5bc6\u6587\u5b57corpid\u4e0d\u5339\u914d");
        }
    }

    public static class PKCS7Padding {
        private static final Charset CHARSET = Charset.forName("utf-8");
        private static final int BLOCK_SIZE = 32;

        public static byte[] getPaddingBytes(int count) {
            int amountToPad = 32 - count % 32;
            if (amountToPad == 0) {
                amountToPad = 32;
            }
            char padChr = PKCS7Padding.chr(amountToPad);
            String tmp = new String();
            for (int index = 0; index < amountToPad; ++index) {
                tmp = tmp + padChr;
            }
            return tmp.getBytes(CHARSET);
        }

        public static byte[] removePaddingBytes(byte[] decrypted) {
            byte pad = decrypted[decrypted.length - 1];
            if (pad < 1 || pad > 32) {
                pad = 0;
            }
            return Arrays.copyOfRange(decrypted, 0, decrypted.length - pad);
        }

        private static char chr(int a) {
            byte target = (byte)(a & 0xFF);
            return (char)target;
        }
    }

    public static class Utils {
        public static String getRandomStr(int count) {
            String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
            Random random = new Random();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                int number = random.nextInt(base.length());
                sb.append(base.charAt(number));
            }
            return sb.toString();
        }

        public static byte[] int2Bytes(int count) {
            byte[] byteArr = new byte[]{(byte)(count >> 24 & 0xFF), (byte)(count >> 16 & 0xFF), (byte)(count >> 8 & 0xFF), (byte)(count & 0xFF)};
            return byteArr;
        }

        public static int bytes2int(byte[] byteArr) {
            int count = 0;
            for (int i = 0; i < 4; ++i) {
                count <<= 8;
                count |= byteArr[i] & 0xFF;
            }
            return count;
        }
    }
}

