/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.safty;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.manage.safty.dao.CmgtSaftyPlanDao;
import com.artfess.manage.safty.dao.CmgtSaftyPlanTaskDao;
import com.artfess.manage.safty.dao.CmgtSaftyTargetDao;
import com.artfess.manage.safty.dao.CmgtSaftyTrainingPlanDao;
import com.artfess.manage.safty.dao.CmgtSaftyTrainingProjectDao;
import com.artfess.manage.safty.dao.CmgtSaftyTrainingRecordDao;
import com.artfess.manage.safty.model.CmgtSaftyPlan;
import com.artfess.manage.safty.model.CmgtSaftyTarget;
import com.artfess.manage.safty.model.CmgtSaftyTrainingProject;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CmgtSaftySelectOptions {
    @Resource
    private CmgtSaftyTrainingProjectDao cmgtSaftyTrainingProjectDao;
    @Resource
    private CmgtSaftyTrainingPlanDao cmgtSaftyTrainingPlanDao;
    @Resource
    UserDao userDao;
    @Resource
    OrgDao orgDao;
    @Resource
    private CmgtSaftyTargetDao cmgtSaftyTargetDao;
    @Resource
    private CmgtSaftyTrainingRecordDao cmgtSaftyTrainingRecordDao;
    @Resource
    private CmgtSaftyPlanTaskDao cmgtSaftyPlanTaskDao;
    @Resource
    private CmgtSaftyPlanDao cmgtSaftyPlakDao;

    public List<CmgtSaftyTarget> getCmgtSaftyTargets() {
        return this.cmgtSaftyTargetDao.selectList(null);
    }

    public List<CmgtSaftyTrainingProject> getCmgtSaftyTrainingProjects() {
        return this.getCmgtSaftyTrainingProjects(null);
    }

    public List<CmgtSaftyTrainingProject> getCmgtSaftyTrainingProjects(String query) {
        if (StringUtil.isEmpty((String)query)) {
            return this.cmgtSaftyTrainingProjectDao.selectList(null);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like((Object)"name_", (Object)("%" + query + "%"));
        return this.cmgtSaftyTrainingProjectDao.selectList((Wrapper)queryWrapper);
    }

    public List<User> getUsers() {
        return this.getUsers(null);
    }

    public List<User> getUsers(String query) {
        if (StringUtil.isEmpty((String)query)) {
            return this.userDao.selectList(null);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like((Object)"FULLNAME_", (Object)("%" + query + "%"));
        return this.userDao.selectList((Wrapper)queryWrapper);
    }

    public List<Org> getOrgs() {
        return this.getOrgs(null);
    }

    public List<Org> getOrgs(String query) {
        if (StringUtil.isEmpty((String)query)) {
            return this.orgDao.selectList(null);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like((Object)"name_", (Object)("%" + query + "%"));
        return this.orgDao.selectList((Wrapper)queryWrapper);
    }

    public List<JSONObject> getCmgtSaftyTrainingPlans() {
        return this.cmgtSaftyTrainingPlanDao.selectList(null).stream().map(p -> JSONUtil.createObj().putOpt("label", (Object)(p.getTrainingDate() + "   " + p.getContent())).putOpt("value", (Object)p.getId())).collect(Collectors.toList());
    }

    public List<JSONObject> getCmgtSaftyTrainingRecords() {
        return this.cmgtSaftyTrainingRecordDao.selectList(null).stream().map(p -> JSONUtil.createObj().putOpt("label", (Object)(p.getTrainingDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) + "  - " + p.getLocation())).putOpt("value", (Object)p.getId())).collect(Collectors.toList());
    }

    public List<JSONObject> getCmgtDutyPlanTasks() {
        return this.cmgtSaftyPlanTaskDao.selectList(null).stream().map(p -> {
            CmgtSaftyPlan plan = (CmgtSaftyPlan)((Object)((Object)this.cmgtSaftyPlakDao.selectById((Serializable)((Object)p.getPlanId()))));
            return JSONUtil.createObj().putOpt("label", (Object)(plan.getName() + " - " + p.getName() + "  -  " + p.getTaskUser() + "  -  " + p.getTaskDate())).putOpt("value", (Object)p.getId());
        }).collect(Collectors.toList());
    }
}

