import req from '@/request.js'
const portal = window.context.portal
export default {
	// 新增安全目标考核
	addCmgtSaftyAppraisal(data, cb) {
		req.post(portal + `/manager/cmgtSaftyCheck/create`, data).then(res => {
			cb(res.data)
		})
	},
	// 修改安全目标考核
	editCmgtSaftyAppraisal(data, cb) {
		req.put(portal + `/manager/cmgtSaftyCheck/updateById`, data).then(res => {
			cb(res.data)
		})
	},
	// 分页查询安全目标考核
	loadCmgtSaftyAppraisal(data, cb) {
		req.post(portal + `/manager/cmgtSaftyCheck/query`, data).then(res => {
			cb(res.data)
		})
	},
	// 批量删除安全目标考核
	deleteCmgtSaftyAppraisal(data, cb) {
		req.remove(portal + `/manager/cmgtSaftyCheck/delete`, data).then(res => {
			cb(res.data)
		})
	},
	// 根据id查询
	getItemById(id, cb) {
		req.get(portal + `/manager/cmgtSaftyCheck/` + id).then(res => {
			cb(res.data)
		})
	},
}
