import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增物资供应商信息
  addCmgtMaterialCustom(data, cb) {
    req.post(portal + `/manager/cmgtMaterialCustom/create`, data).then(res => {
      cb(res.data)
    })
  },
      // 物资供应商排序
  cmgtMaterialCustomManager(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/manager/cmgtMaterialCustom/updateSequence`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 修改物资供应商信息
  editCmgtMaterialCustom(data, cb) {
    req.put(portal + `/manager/cmgtMaterialCustom/update`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询物资供应商信息
  loadCmgtMaterialCustom(data, cb) {
    req.post(portal + `/manager/cmgtMaterialCustom/pageQuery`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除物资供应商信息
  deleteCmgtMaterialCustom(data, cb) {
    req.remove(portal + `/manager/cmgtMaterialCustom/delete`, data).then(res => {
      cb(res.data)
    })
  },
}
