import req from '@/request.js'
const portal = window.context.portal
export default {
  //获取当月物资采购申请单数量
  purchasingCount(data, cb) {
    req.post(portal + `/manager/material/purchasing/count`, data).then(res => {
      cb(res.data)
    })
  },
    //获取采购需求申请列表信息
  applyPurchasingQuery(data, cb) {
    req.post(portal + `/manager/material/purchasing/applyPurchasingQuery`, data).then(res => {
      cb(res.data)
    })
  },
  //分页查询结果
  orderQuery(data, cb) {
    req.post(portal + `/manager/material/order/query`, data).then(res => {
      cb(res.data)
    })
  },
  //供应商信息
  pageQueryQuery(data, cb) {
    req.post(portal + `/manager/cmgtMaterialCustom/pageQuery`, data).then(res => {
      cb(res.data)
    })
  },
  //根据选中的采购申请单ids获取合并后的物资信息
  purchasingFindByIds(data, cb) {
    req.remove(portal + `/manager/material/purchasing/findByIds/?ids=` + data).then(res => {
      cb(res.data)
    })
  },
    //根据id查询实体
  entitiesQuery(data, cb) {
    console.log(data);
    req.get(portal + `/manager/material/order/`+ data).then(res => {
      cb(res.data)
    })
  },
  // 添加实体的接口
    materialOrder(data, cb) {
    req.post(portal + `/manager/material/order/`, data).then(res => {
      cb(res.data)
    })
  },
  // 更新实体
  editMaterialOrder(data, cb) {
    req.put(portal + `/manager/material/order/`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除物资供应商信息
  // deleteMaterialOrder(data, cb) {
  //   req.remove(portal + `/manager/material/order/`, data).then(res => {
  //     cb(res.data)
  //   })
  // },
    deleteMaterialOrder(data) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/manager/material/order/?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
}
