import req from '@/request.js'

const portal = window.context.portal
export default {
  // 服务力量
  serviceTree(cb) {
    req.get(portal + `/manager/cmgtDutyGrid/serviceTree`).then(res => {
      cb(res.data)
    })
  },
  // 所属网格列表
  editCmgtSaftyTarget(cb) {
    req.get(portal + `/manager/cmgtDutyGrid/gridTree`).then(res => {
      cb(res.data)
    })
  },
  getIdList(id, cb) {
    req.get(portal + `/manager/cmgtDutyTeamMemberGpsinfo/statisticsTeamMemberTrack?serviceId=` + id).then(res => {
      cb(res.data)
    })
  },
  getIdListb(id, cb) {
    req.get(portal + `/manager/cmgtDutyTeamMemberGpsinfo/statisticsTeamMemberTrack?gridId=` + id).then(res => {
      cb(res.data)
    })
  },

  // 新增勤务岗位信息
  addCmgtDutyJob(data, cb) {
    req.post(portal + `/cmgtDutyService/v1/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改勤务岗位信息
  editCmgtDutyJob(data, cb) {
    req.put(portal + `/cmgtDutyService/v1/`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询勤务岗位信息
  loadCmgtDutyJob(data, cb) {
    req.post(portal + `/cmgtDutyService/v1/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除勤务岗位信息
  deleteCmgtDutyJob(data, cb) {
    req.remove(portal + `/manager/cmgtDutyJob/delete`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询勤务岗位信息
  getCmgtDutyJobByID(id, cb) {
    req.get(portal + `/cmgtDutyService/v1/` + id).then(res => {
      cb(res.data)
    })
  },
  // 根据岗位id查询人员经纬度
  getCmgtDutyUserLatByID(data, cb) {
    req.get(portal + `/manager/cmgtDutyTeamMemberGpsinfo/queryTeamMemberTrack/?` + data).then(res => {
      cb(res.data)
    })
  },
  // 根据岗位查询人员情况
  getStatisticsTeamMemberTrack(id, cb) {
    req.get(portal + `/manager/cmgtDutyTeamMemberGpsinfo/statisticsTeamMemberTrack/?jobId=` + id).then(res => {
      cb(res.data)
    })
  },
  // 根据人员id查询区域
  getAreaCodeByPersonId(id, cb) {
    req.get(portal + `/manager/duty/member/getJobId/?id=` + id).then(res => {
      cb(res.data)
    })
  },
  // 分页查询设备绑定队员信息
  loadDeviceBoundPlayer(data, cb) {
    req.post(portal + `/manager/duty/member/queryDeviceMemberPage`, data).then(res => {
      cb(res.data)
    })
  },
  // 给队员绑定/解绑设备 /manager/duty/member/updateDeviceCodeId
  deviceBindingUnbinding(data, cb) {
    console.log(data, '传参')
    const {formData, queryString} = data
    req.post(portal + `/cmgtDutyService/v1/bathBind?${queryString}`, formData).then(res => {
      cb(res.data)
    })
  },
  getAllOrgTree(params, cb) { // 获取组织树
    console.log(params, '传入id')
    const serviceId = params.serviceId
    req.get(portal + '/manager/cmgtDutyOrgWorkarrange/service/tree?serviceId=' + serviceId).then(res => {
      cb(res)
    })
  }

}
