import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 新增案件
export function caseAdd(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/cmgtCaseSimple/v1/add`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 修改案件
export function edit(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/cmgtCaseSimple/v1/edit`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 上传文件
export function fileUpload(data = {}) {
  return new Promise((resolve, reject) => {
    let formData = new FormData()
    Object.keys(data).forEach(key => {
      formData.append(key, data[key])
    })
    req.post(portal + `/file/v1/fileUpload`, formData)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获得我的案件分页数据
export function listData(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/cmgtCaseSimple/v1/query`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 获得案件详情
export function details(id = '') {
  return new Promise((resolve, reject) => {
    req.get(portal + `/cmgtCaseSimple/v1/details?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}










