export const gisCompMixin = {
  data() {
    return {
      sectionMarker: null, // 标记点
      infoWin: null, // 信息窗
      showInfo: false, // 信息窗内组件显示与否
      tableHeight: 200,
      isInitMarkers: true,
      tabComp: false,
      layers: [],
      LayerGroup: null, // layerGroup 收集用于切换删除
      markerslayer: [], //集合标点的layer 收集用于切换删除
      searchClear: false, // 切换清除图层
	  markerInfoWin:null
    }
  },
  inject: ['mapData'],
  created() {
    let mapData = this.mapData()
    this.L = mapData.L
    this.map = mapData.map
    this.baseMapOverlay = mapData.baseMapOverlay
  },
  mounted() {
    this.$nextTick(() => {
      this.calcTableHeight()
    })
    this.$root.$on('resize', () => {
      this.calcTableHeight(500)
    })
    this.$bus.$on('contentPanleToggle', () => {
      this.$nextTick(() => {
        this.calcTableHeight()
      })
    })
  },
  beforeDestroy() {
    this.clearMarkers()
  },
  methods: {
    // 清除图层
    clearMarkers() {
      // 清除单个标点
      if (this.sectionMarker) {
        this.map.removeLayer(this.sectionMarker)
        this.sectionMarker = null
      }
      // 清除集合标点
      if (this.LayerGroup) {
        this.LayerGroup.clearLayers();
        this.LayerGroup = null
      }
      // this.map.addLayer(this.baseMapOverlay)
      // this.baseMapOverlay.bringToBack()

      // 自定义删除
      if (this.customClear) {
        this.customClear();
      }
      this.map.closePopup()
      this.showInfo = false
      let center = [29.865585, 106.499857]
      this.map.setView(center, 10)

    },
    // 点击列表行创建对应标点
    rowClick(row) {
      if (!row[this.lt] || !row[this.lg]) {
        this.$message.warning('暂无点位数据')
        return
      }
      this.currentPoint = row
      let latlng = this.createdLngLat(row[this.lt], row[this.lg])
      this.drawMarker(latlng, row, false)
    },
    // 初始化多个标点
    initMarkers() {
      console.log("init")
      this.LayerGroup = null
      this.markerslayer = []
      this.filterData.forEach((row, index) => {
        if (!row[this.lt] || !row[this.lg]) {
          console.log("索引" + index + "无定位数据", row)
          return
        }
        let latlng = this.createdLngLat(row[this.lt], row[this.lg])
        let sectionMarker = this.drawMarker(latlng, row, true)
        this.markerslayer.push(sectionMarker);
      })
      this.LayerGroup = new L.layerGroup(this.markerslayer);
      this.map.addLayer(this.LayerGroup);
    },
    // 创建坐标点
    createdLngLat(lt, lg) {
      let latlng = new L.LatLng(lt, lg)
      return latlng
    },
    // 创建信息窗体
    infoWindow(
      maxHeight = 300,
      minWidth = 300,
      maxWidth = 600,
      minHeight = null
    ) {
      let sContent = this.$refs[this.modelName].$el
      var infoWin = new this.L.popup({
        autoPan: true,
        maxHeight,
        minWidth,
        maxWidth
      }).setContent(sContent)
      return infoWin
    },
    // 创建icon
    createdIcon(iconUrl) {
      let icon = new L.icon({
        iconUrl: iconUrl,
        iconSize: new L.point(24, 24),
        iconAnchor: new L.point(12, 20)
      })
      return icon
    },
    // 创建标点 （单个或多个）
    drawMarker(latlng, item, group) {
      let icon
      if (this.typeIcon) {
        let iconUrl = this[`iconUrl${item[this.iconTypeKey]}`]
        icon = this.createdIcon(iconUrl)
      } else {
        icon = this.createdIcon(this.iconUrl)
      }
      // 标点
      if (!group) {
        if (this.sectionMarker) {
          this.map.removeLayer(this.sectionMarker)
          this.sectionMarker = null
        }
        this.sectionMarker = new L.marker(latlng, {
          icon
        })
		
		let openTooltips
		if(item.stnm){
			openTooltips=this.sectionMarker.bindTooltip(item.stnm)
		}else if(item.hystName){
			openTooltips=this.sectionMarker.bindTooltip(item.hystName)
		}else if(item.rsnm&&!item.mpnm){
			openTooltips=this.sectionMarker.bindTooltip(item.rsnm)
		}else if(item.name){
			openTooltips=this.sectionMarker.bindTooltip(item.name)
		}else if(item.mpnm){
			openTooltips=this.sectionMarker.bindTooltip(item.mpnm)
		}
        this.infoWin = this.infoWindow()
        this.sectionMarker.addEventListener('popupclose', () => {
          if (this.popupclose) {
            this.popupclose()
          }
        })
        this.sectionMarker.addEventListener('popupopen', () => {
          if (this.popupopen) {
            this.popupopen()
          }
        })
        this.sectionMarker.addEventListener('click', () => {
          this.currentPoint = item
          this.infoWin.update()
          this.showInfo = true
          this.map.setView(this.sectionMarker.getLatLng(), 14)
          // this.sectionMarker.openPopup(this.infoWin)
          //   this.sectionMarker.bindPopup(this.infoWin).openPopup()
          // this.sectionMarker.addTo(this.map).bindPopup(this.infoWin)
        })
		this.sectionMarker.addEventListener('mouseover', () => {
			openTooltips.openTooltip()
		})
        // 将标注添加到地图中
        this.map.addLayer(this.sectionMarker)
        this.showInfo = true
        this.sectionMarker.bindPopup(this.infoWin).openPopup()
        this.map.setView(this.sectionMarker.getLatLng(), 14)
      } else {
        const sectionMarker = new L.marker(latlng, {
          icon
        })
        let infoWin = this.infoWindow()
		let openTooltips
		if(item.stnm){
			openTooltips=sectionMarker.bindTooltip(item.stnm)
		}else if(item.hystName){
			openTooltips=sectionMarker.bindTooltip(item.hystName)
		}else if(item.rsnm&&!item.mpnm){
			openTooltips=sectionMarker.bindTooltip(item.rsnm)
		}else if(item.name){
			openTooltips=sectionMarker.bindTooltip(item.name)
		}else if(item.mpnm){
			openTooltips=sectionMarker.bindTooltip(item.mpnm)
		}
        sectionMarker.addEventListener('popupclose', () => {
          if (this.popupclose) {
            this.popupclose()
          }
        })
        sectionMarker.addEventListener('popupopen', () => {
          if (this.popupopen) {
            this.popupopen()
          }
        })
		sectionMarker.addEventListener('mouseover', () => {
			openTooltips.openTooltip()
		})
        sectionMarker.addEventListener('click', () => {
          this.currentPoint = item
          infoWin.update()
          this.showInfo = true
          //   sectionMarker.bindPopup(this.infoWin).openPopup()
          this.map.setView(sectionMarker.getLatLng(), 14)
        })
        // 将标注添加到地图中
        // this.map.addLayer(sectionMarker)
        sectionMarker.addTo(this.map).bindPopup(infoWin)
        return sectionMarker;
      }
    },
    // 计算table高度
    calcTableHeight(delay) {
      setTimeout(() => {
        if (!this.tabComp) {
          if (!this.$refs.comContainer || !this.$refs.searchPanle) {
            return
          }
          const comContainer = this.$refs.comContainer.clientHeight
          const searchPanle = this.$refs.searchPanle.clientHeight
          // 38-- padding: 14 0  , searchPanle margin-bottom :10
          this.tableHeight = comContainer - searchPanle - 38
        } else {
          if(!this.$refs[`comContainer_${this.activeName}`][0].$el){
            return
          }
          if(!this.$refs[`searchPanle_${this.activeName}`][0]){
            return
          }
          const comContainer = this.$refs[`comContainer_${this.activeName}`][0]
            .$el.clientHeight
          const searchPanle = this.$refs[`searchPanle_${this.activeName}`][0]
            .clientHeight
          // 38-- padding: 14 0  , searchPanle margin-bottom :10
          this.tableHeight = comContainer - searchPanle - 10
        }
      }, delay || 0)
    }
  }
}