import req from "@/request.js";

const portal = window.context.portal;
export default {
	//字典
	getSys(data, cb) {
		req.post(portal + `/sys/sysDictionary/v1/queryDictItemsByCode`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 行政区查询接口
	getbasAdName(data, cb) {
		req.post(portal + `/sys/sysAreas/v1/tree`, data).then(rep => {
			cb(rep.data);
		});
	},
	//获取水库下拉
	getWater(data, cb) {
		req.post(portal + `/att/res/base/findAll`, data).then(rep => {
			cb(rep.data);
		});
	},

	// 除险加固

	// 新增
	addSaveRes(data, cb) {
		req.post(portal + `/wrp/rsr/reinforce/create`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 分页
	ListGetRes(data, cb) {
		req.post(portal + `/wrp/rsr/reinforce/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 修改
	detailIdRes(id, cb) {
		req.get(portal + `/wrp/rsr/reinforce/get/` + id).then(rep => {
			cb(rep.data);
		});
	},
	// 确认修改
	upDataRes(data, cb) {
		req.post(portal + `/wrp/rsr/reinforce/updateById`, data).then(rep => {
			cb(rep.data);
		});
	},
	//删除
	removeRes(ids, cb) {
		req.get(portal + `/wrp/rsr/reinforce/deleteByIds?ids=` + ids).then(rep => {
			cb(rep.data);
		});
	},

	//安全鉴定
	//新增
	addSaveSaf(data, cb) {
		req.post(portal + `/wrp/rsr/appraisal/create`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 分页
	ListGetSaf(data, cb) {
		req.post(portal + `/wrp/rsr/appraisal/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 修改
	detailIdSaf(id, cb) {
		req.get(portal + `/wrp/rsr/appraisal/get/` + id).then(rep => {
			cb(rep.data);
		});
	},
	// 确认修改
	upDataSaf(data, cb) {
		req.post(portal + `/wrp/rsr/appraisal/updateById`, data).then(rep => {
			cb(rep.data);
		});
	},
	//删除
	removeSaf(ids, cb) {
		req.get(portal + `/wrp/rsr/appraisal/deleteByIds?ids=` + ids).then(rep => {
			cb(rep.data);
		});
	},


	// 维修保养

	//新增
	addSaveMain(data, cb) {
		req.post(portal + `/wrp/rsr/maintain/create`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 分页
	ListGetMain(data, cb) {
		req.post(portal + `/wrp/rsr/maintain/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 修改
	detailIdMain(id, cb) {
		req.get(portal + `/wrp/rsr/maintain/get/` + id).then(rep => {
			cb(rep.data);
		});
	},
	// 确认修改
	upDataMain(data, cb) {
		req.post(portal + `/wrp/rsr/maintain/updateById`, data).then(rep => {
			cb(rep.data);
		});
	},
	//删除
	removeMain(ids, cb) {
		req.get(portal + `/wrp/rsr/maintain/deleteByIds?ids=` + ids).then(rep => {
			cb(rep.data);
		});
	},


	//应急预案

	//新增
	addSaveCon(data, cb) {
		req.post(portal + `/wrp/rsrReserve/Plan/create`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 分页
	ListGetCon(data, cb) {
		req.post(portal + `/wrp/rsrReserve/Plan/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 修改
	detailIdCon(id, cb) {
		req.get(portal + `/wrp/rsrReserve/Plan/get/` + id).then(rep => {
			cb(rep.data);
		});
	},
	// 确认修改
	upDataCon(data, cb) {
		req.post(portal + `/wrp/rsrReserve/Plan/updateById`, data).then(rep => {
			cb(rep.data);
		});
	},
	//删除
	removeCon(ids, cb) {
		req.get(portal + `/wrp/rsrReserve/Plan/deleteByIds?ids=` + ids).then(rep => {
			cb(rep.data);
		});
	},


	//水位库容
	addcapacity(data, cb) {
		req.post(portal + `/wrp/rsr/lvtpc/create`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 分页
	ListGetConcapacity(data, cb) {
		req.post(portal + `/wrp/rsr/lvtpc/query`, data).then(rep => {
			cb(rep.data);
		});
	},
	// 修改
	detailIdConcapacity(id, cb) {
		req.get(portal + `/wrp/rsr/lvtpc/get/` + id).then(rep => {
			cb(rep.data);
		});
	},
	// 确认修改
	upDataConcapacity(data, cb) {
		req.post(portal + `/wrp/rsr/lvtpc/updateById`, data).then(rep => {
			cb(rep.data);
		});
	},
	//删除
	removeConcapacity(ids, cb) {
		req.get(portal + `/wrp/rsr/lvtpc/deleteByIds?ids=` + ids).then(rep => {
			cb(rep.data);
		});
	},
	
	
	//巡查账号
	//添加
	addResIns(data,cb){
		req.post(portal +'/att/res/base/addResIns',data).then(rep => {
			cb(rep.data);
		});
	},
	//删除
	deleteResIns(data,cb){
		req.get(portal + `/att/res/base/deleteResIns?ids=` + data).then(rep => {
			cb(rep.data);
		});
	},
	//查询
	resInsList(data,cb){
		req.get(portal + `/att/res/base/getResInsList/${data}` ).then(rep => {
			cb(rep.data);
		});
	},
	//修改
	updateResIns(data,cb){
		req.post(portal +'/att/res/base/updateResIns',data).then(rep => {
			cb(rep.data);
		});
	}
}
