let basicFormCodeHtml = {
  code: `<template>
  <div>
    <form data-vv-scope="form1" v-form name="online-form">
      <table class="form-table" cellspacing="0" cellpadding="0" border="0">
        <tbody>
          <tr>
            <th class="group-th" colspan="4">基础控件演示</th>
          </tr>
          <tr v-permit="4">
            <th width="10%">htTimeSelect：</th>
            <td width="40%">
              <ht-time-select v-model="data.xxb.timeselect" validate="required" />
            </td>
            <th width="10%">htTimeSelect：</th>
            <td width="40%">
              <ht-time-select v-model="data.xxb.timeselect2" permission="r" validate="required" />
            </td>
          </tr>
          <tr v-permit="4">
            <th width="10%">htTimePicker：</th>
            <td width="40%">
              <ht-time-picker v-model="data.xxb.timepicker"  validate="required" />
              <pre>{{data.xxb.timepicker}}</pre>
            </td>
            <th width="10%">htTimePicker2：</th>
            <td width="40%">
              <ht-time-picker v-model="data.xxb.timepicker2" permission="r" validate="required" />
            </td>
          </tr>
        </tbody>
      </table>
      <table class="form-table" cellspacing="0" cellpadding="0" border="0">
        <tbody>
          <tr>
            <th class="group-th" colspan="4">基础表单</th>
          </tr>
          <tr v-permit="4">
            <th width="10%" v-if="permission.fields.grxx.xm!='n'">
              <span v-if="permission.fields.grxx.xm=='b'">*</span>
              姓名：
            </th>
            <td width="40%" v-if="permission.fields.grxx.xm!='n'">
              <ht-input
                v-model="data.xxb.xm"
                :permission="permission.fields.grxx.xm"
                :validate="validate.xm"
                placeholder="请输入您的姓名"
              />
            </td>
            <th width="10%" v-if="permission.fields.grxx.xb!='n'">
              <span v-if="permission.fields.grxx.xb=='b'">*</span>
              性别：
            </th>
            <td width="40%" v-if="permission.fields.grxx.xb!='n'">
              <ht-radio
                v-model="data.xxb.xb"
                option-layout="vertical"
                permission="w"
                :options="options.xb"
                :props="{key:'code',value:'desc'}"
              />
            </td>
          </tr>
          <tr v-permit="4">
            <th width="10%">爱好：</th>
            <td width="40%">
              <ht-checkbox
                v-model="data.xxb.ah"
                :options="options.ah"
                option-layout="vertical"
                :min="1"
                :max="3"
                :linkage="[{'value':'1','effect':[{'target':'permission.fields.grxx.xm', 'type': '=','value':'w'},{'target': 'validate.xm', 'type': '+', 'value': {'mobile':true}}]},{'value':'2','effect':[{'target': 'validate.xm', 'type': '-', 'value': 'required'}]}]"
                :permission="permission.fields.grxx.ah"
                :validate="{'required':false}"
              />
            </td>
            <th width="10%">家庭住址：</th>
            <td width="40%">
              <ht-input
                type="textarea"
                v-model="data.xxb.jtzz"
                :validate="{method: {callback: callback, message: '校验失败，必须输入test。'}}"
                permission="w"
              />
            </td>
          </tr>
          <tr v-permit="4">
            <th width="10%">出生日期：</th>
            <td>
              <ht-date
                v-model="data.xxb.csrq"
                :validate="{'required':true,'isEnd':data.xxb.bysj}"
                format="hh:mm:ss"
                value-format="yyyy-MM-dd"
                :showDate="true"
                :day="-3"
              />
            </td>
            <th>毕业时间：</th>
            <td>
              <ht-date
                v-model="data.xxb.bysj"
                name="bysj"
                format="yyyy-MM-dd"
                value-format="yyyy-MM-dd"
              />
            </td>
          </tr>
          <tr v-permit="4">
            <th>毕业时年龄（天）：</th>
            <td>
              <ht-input
                v-model="data.xxb.bynl"
                :date-calc-exp="{'start':'data.xxb.csrq','end':'data.xxb.bysj','diffType':'day'}"
              />
            </td>
            <th>毕业时年龄：</th>
            <td>
              <ht-input v-model="data.xxb.bynly" math-exp="{毕业时年龄天(data.xxb.bynl)}/365" />
            </td>
          </tr>
          <tr v-permit="4">
            <th>下拉异步只读：</th>
            <td>
              <ht-select
                v-model="data.xxb.zyd"
                :options="options.zy"
                :remote-method="handleSelectOptions"
                permission="r"
                :validate="{'required':true}"
                :linkage="{value: '2', effect: [{target:'permission.fields.grxx.ah', type:'=', value: 'r'}]}"
              ></ht-select>
            </td>
            <th>htSelect默认用法固定选项只读：</th>
            <td>
              <ht-select
                v-model="data.xxb.zyc"
                :options="options.zy2"
                permission="r"
                :validate="{'required':true}"
                :linkage="{value: '2', effect: [{target:'permission.fields.grxx.ah', type:'=', value: 'r'}]}"
              ></ht-select>
            </td>
          </tr>
          <tr v-permit="4">
            <th>htSelect默认用法：</th>
            <td>
              <ht-select
                v-model="data.xxb.zyb"
                :options="options.zy"
                :remote-method="handleSelectOptions"
                :validate="{'required':true}"
                :linkage="{value: '2', effect: [{target:'permission.fields.grxx.ah', type:'=', value: 'r'}]}"
              ></ht-select>
            </td>
            <th>select默认插槽用法：</th>
            <td>
              <ht-select
                v-model="data.xxb.zya"
                :options="[{key:'a',value:'a',children:[ {key:'1',value:'医生'},{key:'2',value:'护士'}]},{key:'水果',value:'水果',children:[ {key:'a',value:'苹果'},{key:'b',value:'香蕉'}]}]"
                :validate="{'required':true}"
                :linkage="{value: '2', effect: [{target:'permission.fields.grxx.ah', type:'=', value: 'r'}]}"
              >
                <template slot-scope="{ options }">
                  <el-option-group v-for="group in options" :key="group.key" :label="group.value">
                    <el-option
                      v-for="item in group.children"
                      :key="item.key"
                      :label="item.value"
                      :value="item.key"
                    ></el-option>
                  </el-option-group>
                </template>
              </ht-select>
            </td>
          </tr>
          <tr v-permit="4">
            <th>职业（分组）：</th>
            <td>
              <ht-select
                v-model="data.xxb.zy"
                :options="[{key:'a',value:'a',children:[ {key:'1',value:'医生'},{key:'2',value:'护士'}]},{key:'水果',value:'水果',children:[ {key:'a',value:'苹果'},{key:'b',value:'香蕉'}]}]"
                :validate="{'required':true}"
                multiple
                permission="r"
                :linkage="{value: '2', effect: [{target:'permission.fields.grxx.ah', type:'=', value: 'r'}]}"
              >
                <template slot-scope="{ options,propKey,propValue }">
                  <el-option-group v-for="group in options" :key="group.key" :label="group.value">
                    <el-option
                      v-for="item in group.children"
                      :key="item[propKey]"
                      :label="item[propValue]"
                      :value="item[propKey]"
                    ></el-option>
                  </el-option-group>
                </template>
              </ht-select>
            </td>
            <th>职业2 htselect slot：</th>
            <td>
              <ht-select
                v-model="data.xxb.zye"
                :options="options.zy"
                :remote-method="handleSelectOptions"
                :validate="{'required':true}"
                :linkage="{value: '2', effect: [{target:'permission.fields.grxx.ah', type:'=', value: 'r'}]}"
              >
                <template slot-scope="{ options,propKey,propValue }">
                  <el-option
                    v-for="item in options"
                    :key="item[propKey]"
                    :label="item[propValue]"
                    :value="item[propKey]"
                  ></el-option>
                </template>
              </ht-select>
            </td>
          </tr>
          <tr v-permit="4">
            <th>附件资料：</th>
            <td>
              <ht-file
                v-model="data.xxb.fjzl"
                permission="w"
                :size="100"
                :limit="2"
                :validate="{'required':true}"
              />
            </td>
          </tr>
          <tr v-permit="4">
            <th>所在维度：</th>
            <td>
              <my-demension
                v-model="data.xxb.szwd"
                permission="w"
                :config="{id:'data.xxb.szwdId',code: 'data.xxb.szwdCode'}"
                placeholder="选择你所在的维度"
              />
            </td>
            <th width="10%">合计：</th>
            <td>
              <ht-input
                v-model="data.xxb.hj"
                multiple
                math-exp="FormMath.convertCurrency(FormMath.sum([{小计(data.xxb.sub_bxxx.xj)}]))"
              />
            </td>
          </tr>
          <tr v-permit="4">
            <th>角色选择：</th>
            <td>
              <my-role-selector
                v-model="data.xxb.roles"
                permission="w"
                :config="{id:'data.xxb.roleId',code: 'data.xxb.roleCode'}"
                placeholder="请选择"
              />
            </td>
            <th width="10%">用户选择：</th>
            <td>
              <my-user-selector
                v-model="data.xxb.users"
                permission="w"
                :config="{id:'data.xxb.userIds',fullname: 'data.xxb.userFullnames',account: 'data.xxb.userAccounts'}"
                placeholder="请选择"
              />
            </td>
          </tr>
          <tr v-permit="4">
            <th>时间选择（分）：</th>
            <td>
              <ht-duration v-model="data.xxb.second" placeholder="请选择" validate="required" />
            </td>
            <th width="10%">时间选择（秒）：</th>
            <td>
              <ht-duration
                type="second"
                v-model="data.xxb.second2"
                placeholder="请选择"
                validate="required"
              />
              <el-button type="button" @click="data.xxb.second2=0">second2</el-button>
            </td>
          </tr>
          <tr v-permit="4">
            <th>价格1：</th>
            <td>
              <ht-input v-model="data.xxb.price1" />
              <ht-input v-model="data.xxb.price2" />
            </td>
            <th width="10%">总价：</th>
            <td>
              <ht-input
                v-model="data.xxb.price3"
                math-exp="{数字1(data.xxb.price1)}+{数字2(data.xxb.price2)}"
              />
            </td>
          </tr>

          <tr>
            <th class="group-th" colspan="4">子表</th>
          </tr>
          <tr>
            <td colspan="4">
              <table class="form-table" cellspacing="0" cellpadding="0" border="0">
                <thead>
                  <tr class="sub-table-header">
                    <th>报销项目</th>
                    <th>单价</th>
                    <th>数量</th>
                    <th>小计</th>
                    <th>开始时间</th>
                    <th>结束时间</th>
                    <th width="150">持续时间(分钟)</th>
                    <th width="180">操作</th>
                  </tr>
                </thead>
                <tbody>
                  <tr
                    v-for="(item, index) in data.xxb.sub_bxxx"
                    :key="index"
                    :data-index="index"
                    data-subname="data.xxb.sub_bxxx"
                  >
                    <td>
                      <my-demension
                        v-model="item.bxxm"
                        :config="{id:'item.dj',code: 'item.sl'}"
                        placeholder="选择你所在的维度"
                      />
                    </td>
                    <td>
                      <ht-input v-model="item.dj" />
                    </td>
                    <td>
                      <ht-input v-model="item.sl" />
                    </td>
                    <td>
                      <ht-input v-model="item.xj" math-exp="{单价(item.dj)}*{数量(item.sl)}" />
                    </td>
                    <td>
                      <ht-date
                        v-model="item.begin"
                        format="yyyy-MM-dd"
                        :validate="{'required':true,'isEnd':'itemEnd'}"
                      />
                    </td>
                    <td>
                      <ht-date v-model="item.end" format="yyyy-MM-dd" name="itemEnd" />
                    </td>
                    <td>
                      <ht-input
                        v-model="item.cxsj"
                        :date-calc-exp="{'start':'item.begin','end':'item.end','diffType':'minute'}"
                      />
                    </td>
                    <td class="trash">
                      <el-button size="small" type="text" @click="data.xxb.sub_bxxx.remove(item)">删除</el-button>
                      <el-button
                        size="small"
                        type="text"
                        @click="move(data.xxb.sub_bxxx, item, 'up')"
                      >上移</el-button>
                      <el-button
                        size="small"
                        type="text"
                        @click="move(data.xxb.sub_bxxx, item, 'down')"
                      >下移</el-button>
                      <el-button
                        size="small"
                        type="text"
                        @click="data.xxb.sub_bxxx.push({...item})"
                      >复制</el-button>
                    </td>
                  </tr>
                </tbody>
                <tfoot>
                  <tr>
                    <td colspan="15">
                      <el-button
                        size="small"
                        type="text"
                        icon="el-icon-plus"
                        @click="data.xxb.sub_bxxx.push({})"
                      >添加</el-button>
                    </td>
                  </tr>
                </tfoot>
              </table>
            </td>
          </tr>
        </tbody>
      </table>
    </form>
    <pre>{{data}}</pre>
    <el-button
      style="margin-top: 20px"
      :loading="loading"
      size="small"
      type="primary"
      @click="submit"
    >提交</el-button>
  </div>
</template>
<script>
import utils from "@/utils.js";
import service from "@/service.js";
import { Message } from "element-ui";
import { setTimeout } from "timers";
import { Promise } from "q";
import MyDemension from "@/demo/MyDemension.vue";
import MyRoleSelector from "@/demo/MyRoleSelector.vue";
import MyUserSelector from "@/demo/MyUserSelector.vue";

export default {
  name: "basic-form",
  components: {
    MyDemension,
    MyRoleSelector,
    MyUserSelector
  },
  data() {
    return {
      loading: false,
      data: {
        xxb: {
          timeselect: "08:15",
          timeselect2: "08:30",
          timepicker: null,
          timepicker2: "2024-06-16 20:09:38",
          zy: "1,2",
          zyc: "1",
          zyd: "2",
          xm: "张三",
          xb: false,
          ah: "1,3",
          csrq: "1986-6-29",
          bysj: "2008-6-30",
          szwd: "二维,三维，四维",
          roles: "行政角色",
          second: 3720,
          second2: 2200,
          fjzl:
            '[{"name":"更新日志.txt","size":12764,"percentage":100,"status":"success","state":"success"}]',
          sub_bxxx: []
        }
      },
      permission: {
        fields: {
          grxx: {
            xm: "b",
            xb: "w",
            ah: "w"
          }
        }
      },
      validate: {
        xm: null
      },
      options: {
        ah: [
          { key: "1", value: "爬山" },
          { key: "2", value: "游泳" },
          { key: "3", value: "美食" },
          { key: "4", value: "下棋" }
        ],
        xb: [
          { code: 0, desc: "男士", disabled: true },
          { code: true, desc: "女士" },
          { code: false, desc: "无性" }
        ],
        zy: null,
        zy2: [
          { key: "1", value: "医生" },
          { key: "2", value: "护士" },
          { key: "3", value: "老师" }
        ]
      }
    };
  },
  methods: {
    callback: value => {
      return value == "test";
    },
    handleSelectOptions: function(query) {
      let _me = this;
      return new Promise((resolve, reject) => {
        setTimeout(() => {
          _me.options.zy = _me.options.zy2;
          resolve();
        }, 1000);
      });
    },
    move: function(ary, item, direct) {
      this.data.xxb.sub_bxxx = utils.arrayMove(ary, item, direct);
    },
    submit: function() {
      this.loading = true;
      setTimeout(() => {
        utils
          .validateForm(this, "form1")
          .then(r => {
            Message.success(JSON.stringify(this.data));
          })
          .catch(items => {
            Message.error("有n个字段未通过校验，无法提交表单。");
          })
          .finally(() => {
            this.loading = false;
          });
      }, 500);
    }
  }
};
</script>`
}

export default basicFormCodeHtml;