let InputCode = {
  singleText: `<ht-input prefix-icon="icon-account" v-model="data.name" placeholder="姓名" />`,
  numberText: `<ht-input type="number" v-model="data.age" placeholder="年龄" :step="2" :min="12" :max="99" />`,
  multipleText: `
  <ht-input
    type="textarea"
    v-model="data.memo"
    :cols="80"
    :autosize="{ minRows: 2, maxRows: 4}"
    placeholder="备注"
  />`,
  permission: `
  <div>
      <ht-radio
          v-model="permission.xm"
          :options="[{key:'r',value:'只读'},{key:'w',value:'编辑'},{key:'b',value:'必填'}]" />
      <el-divider />
      <ht-input v-model="data.xm" :permission="permission.xm" placeholder="请输入您的姓名" />
  </div>
  <script>
  export default {
    data(){
      return {
        data: {
          xm: null
        },
        permission: {
          xm: "w"
        }
      };
    }
  }
  <\/script>`,
  selectPermission: `
  <div>
  <label class="item-label">权限控制:</label>
  <ht-radio
    v-model="permission.xlk"
    :options="[{key:'r',value:'只读'},{key:'w',value:'编辑'},{key:'b',value:'必填'}]"
  />
  <el-divider />
  <ht-select v-model="data.xlk" :permission="permission.xlk" :options="options.xlk" />

  <el-button
    size="small"
    style="margin-left:10px"
    type="danger"
    @click="options.xlk=[]"
  >清空下拉框选项</el-button>
</div>`,
  math: `
  <div v-form>
    <label class="item-label">相加:</label>
    <div class="flex">
      <ht-input class="m-r" v-model="data.math1" placeholder="数字1" />
      <span class="m-r">+</span>
      <ht-input class="m-r" v-model="data.math2" placeholder="数字2" />
      <span class="m-r">=</span>
      <ht-input
        class="m-r"
        v-model="data.math3"
        disabled
        placeholder="数字1 + 数字2"
        math-exp="{数字1(data.math1)} + {数字2(data.math2)}"
      />
    </div>
    <el-divider />
    <div>
      <label class="item-label">子表每行分别计算，再对列求和:</label>
      <br />
      <ul class="math-ul">
        <li
          v-for="(row, index) in data.sub"
          :key="index"
          :data-index="index"
          data-subname="data.sub"
        >
          <div class="flex">
            <ht-input class="m-r" v-model="row.dj" placeholder="单价" />
            <ht-input class="m-r" v-model="row.sl" placeholder="数量" />
            <ht-input
              class="m-r"
              v-model="row.xj"
              placeholder="小计"
              math-exp="{单价(row.dj)} * {数量(row.sl)}"
            />
            <el-link type="danger" class="m-r" @click="data.sub.remove(row)">删除</el-link>
          </div>
        </li>
        <li>
          <div class="flex">
            <el-button
              type="primary"
              class="m-r"
              size="small"
              @click="data.sub.push({})"
            >添加一行数据</el-button>
            <label class="item-label">对子表小计求和:</label>
            <ht-input
              class="m-r"
              v-model="data.math4"
              placeholder="对子表中的小计求和"
              math-exp="FormMath.sum([{小计(data.sub.xj)}])"
            />
          </div>
        </li>
      </ul>
    </div>
  </div>
  <script>
  export default {
    data(){
      return {
        data: {
          math1: null,
          math2: null,
          math3: null,
          sub: [{ dj: null, sl: null, xj: null }]
        }
      };
    }
  }
  <\/script>`,
  linkage: `
  <template>
    <div class="flex">
      <label class="item-label">兴趣爱好(后面的输入框在显示和隐藏之间切换):</label>
      <ht-select
        v-model="data.ah"
        class="m-r"
        :options="[{ key: '1', value: '爬山' },{ key: '2', value: '游泳' },{ key: '3', value: '下棋' }]"
        :linkage="[{'value':'1','effect':[{'target':'permission.shan', 'type': '=','value':'w'}]},
        {'value':'2','effect':[{'target': 'permission.yong', 'type': '=', 'value': 'b'}]},{'value':'3','effect':[{'target': 'permission.qi', 'type': '=', 'value': 'w'}]}]"
      />
      <ht-input :permission="permission.shan" v-model="data.shan" placeholder="喜欢爬哪座山" />
      <ht-input :permission="permission.yong" v-model="data.yong" placeholder="喜欢哪种泳姿" />
      <ht-input :permission="permission.qi" v-model="data.qi" placeholder="喜欢哪种棋" />
    </div>
    <el-divider />
    <div class="flex">
      <label class="item-label">联系方式(后面的输入框会切换不同的校验规则):</label>
      <ht-radio
        v-model="data.lxfs"
        :options="[{ key: '1', value: 'Email' },{ key: '2', value: '手机' }]"
        :linkage="[{'value':'1','effect':[{'target':'validate.lxdz', 'type': '+','value':'email'}]},{'value':'2','effect':[{'target':'validate.lxdz', 'type': '+','value':'phonenumber'}]}]"
      />
      <ht-input v-model="data.lxdz" :validate="validate.lxdz" />
    </div>
    <el-divider />
    <div class="flex">
      <label class="item-label">领款方式(后面的输入框的内容会置空):</label>
      <ht-checkbox
        v-model="data.lkfs"
        :options="[{ key: '1', value: '银行卡' },{ key: '2', value: '现金' }]"
        :linkage="[{'value':'2','effect':[{'target':'data.yhkh', 'type': '=','value':''}]}]"
      />
      <ht-input v-model="data.yhkh" />
    </div>
  </template>
  <script>
  export default {
    data(){
      return {
        data: {
          ah: null,
          shan: null,
          yong: null,
          qi: null,
          sub: [{ dj: null, sl: null, xj: null }]
        },
        permission: {
          shan: "n",
          yong: "n",
          qi: "n"
        },
        validate: {
          yong: null,
          lxdz: {}
        }
      };
    }
  }
  <\/script>`,
  "validation": `
  <template>
    <div class="flex">
      <label class="item-label">选择校验规则：</label>
      <ht-select class="m-r" :options="validate.dic" v-model="validate.current" />
      <div class="m-r" v-if="currentValidateArgsNumber > 0">
        <label class="item-label">第一个参数：</label>
        <ht-input v-model="validate.arg1" placeholder="校验规则的第一个参数" />
      </div>
      <div class="m-r" v-if="currentValidateArgsNumber > 1">
        <label class="item-label">第二个参数：</label>
        <ht-input v-model="validate.arg2" placeholder="校验规则的第二个参数" />
      </div>
      <div class="m-r" v-if="currentValidateHasTarget">
        <label class="item-label">检验关联对象：</label>
        <ht-select
          :options="[{key: 'wb2', value: '输入框二'},{key: 'rq2', value: '结束时间'}]"
          v-model="validate.target"
        />
      </div>
      <div class="m-r" v-if="validate.current=='method'">
        <label class="item-label">自定义方法：</label>
        <ht-input class="m-r" type="textarea" :rows="4" v-model="validate.method" />
        <label class="item-label">提示信息：</label>
        <ht-input v-model="validate.message" />
      </div>
    </div>
    <el-divider />
    <div style="margin-bottom: 15px">
      <el-tooltip class="m-r" v-if="validateExp" content="生成的校验规则">
        <i class="icon-tips" style="font-size: 14px; font-weight: bold;" />
      </el-tooltip>
      <span>{{validateExp}}</span>
    </div>
    <label class="item-label">输入框一：</label>
    <ht-input v-model="data.wb1" :validate="validateExp" />
    <div v-if="currentValidateHasTarget && currentValidateHasTarget!='date'">
      <label class="item-label">输入框二：</label>
      <ht-input v-model="data.wb2" name="wb2" />
    </div>
    <el-divider />
    <div v-if="currentValidateHasTarget=='date'">
      <label class="item-label">开始时间：</label>
      <ht-date class="m-r" v-model="data.rq1" :validate="validateExp" />
      <label class="item-label">结束时间：</label>
      <ht-date v-model="data.rq2" name="rq2" />
    </div>
  </template>
  <script>
  export default {
    data(){
      return {
        validate: {
          dic: ValidateDic,
          current: null,
          arg1: null,
          arg2: null,
          target: null,
          method: null,
          message: null,
          yong: null,
          lxdz: null
        }
      };
    },
    computed: {
      currentValidateArgsNumber: function() {
        return this.validate.current
          ? this.validate.dic.find(m => m.key == this.validate.current)["args"]
          : 0;
      },
      currentValidateHasTarget: function() {
        return this.validate.current
          ? this.validate.dic.find(m => m.key == this.validate.current)["target"]
          : false;
      },
      validateExp: function() {
        if (this.validate.current == "method" && this.validate.method) {
          let _method = null;
          try {
            _method = eval(\`($\{this.validate.method\})\`);
          } catch (e) {}
          if (_method && typeof _method == "function") {
            if (this.validate.message) {
              return {
                method: { callback: _method, message: this.validate.message }
              };
            } else {
              return { method: _method };
            }
          }
          return null;
        }
        if (this.currentValidateHasTarget) {
          return this.validate.target
            ? \`$\{this.validate.current\}:$\{this.validate.target\}\`
            : this.validate.current;
        }
        if (this.currentValidateArgsNumber == 1) {
          return this.validate.arg1
            ? \`$\{this.validate.current\}:$\{this.validate.arg1\}\`
            : this.validate.current;
        }
        if (this.currentValidateArgsNumber == 2) {
          return this.validate.arg1 && this.validate.arg2
            ? \`$\{this.validate.current\}:$\{this.validate.arg1\},$\{this.validate.arg2\}\`
            : this.validate.current;
        }
        return this.validate.current;
      }
    }
  }
  <\/script>`,
  anchors: [
    {
      content: "单行文本",
      alias: "singleText"
    },
    {
      content: "数字输入框",
      alias: "numberText"
    },
    {
      content: "多行文本",
      alias: "multipleText"
    },
    {
      content: "数学计算",
      alias: "mathCalculation"
    },
    {
      content: "联动",
      alias: "linkage"
    },
    {
      content: "校验规则",
      alias: "validation"
    },
    {
      content: "权限控制",
      alias: "permission"
    },
    {
      content: "下拉框权限控制",
      alias: "selectPermission"
    },
    {
      content: "API",
      alias: "api"
    }
  ]
}

export default InputCode;