/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.tdengine.things;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetlinks.community.tdengine.things.TDengineThingDataHelper;
import org.jetlinks.community.things.data.operations.ColumnModeSaveOperationsBase;
import org.jetlinks.community.things.data.operations.DataSettings;
import org.jetlinks.community.things.data.operations.MetricBuilder;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.things.ThingsRegistry;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.Predicate3;

class TDengineColumnModeSaveOperations
extends ColumnModeSaveOperationsBase {
    private final TDengineThingDataHelper helper;
    static Set<String> IGNORE_COLUMN = new HashSet<String>(Arrays.asList("id", "timestamp"));

    public TDengineColumnModeSaveOperations(ThingsRegistry registry, MetricBuilder metricBuilder, DataSettings settings, TDengineThingDataHelper helper) {
        super(registry, metricBuilder, settings);
        this.helper = helper;
    }

    protected String createPropertyDataId(ThingMessage message) {
        return message.getMessageId();
    }

    protected Map<String, Object> handlePropertiesData(ThingMetadata metadata, Map<String, Object> properties) {
        properties = super.handlePropertiesData(metadata, properties);
        IGNORE_COLUMN.forEach(properties::remove);
        return properties;
    }

    protected boolean isTagValue(String metric, String key, Object value) {
        return Objects.equals(this.metricBuilder.getThingIdProperty(), key);
    }

    protected Mono<Void> doSave(String metric, TimeSeriesData data) {
        return this.helper.doSave(metric, data, (Predicate3<String, String, Object>)((Predicate3)this::isTagValue));
    }

    protected Mono<Void> doSave(String metric, Flux<TimeSeriesData> data) {
        return this.helper.doSave(metric, data, (Predicate3<String, String, Object>)((Predicate3)this::isTagValue));
    }
}

