/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.tdengine.restful;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.executor.DefaultColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.ColumnWrapperContext;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrapper;
import org.jetlinks.community.tdengine.TDEngineQueryOperations;
import org.jetlinks.community.tdengine.TDEngineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

public class RestfulTDEngineQueryOperations
implements TDEngineQueryOperations {
    private static final Logger log = LoggerFactory.getLogger(RestfulTDEngineQueryOperations.class);
    private final WebClient client;
    private final String database;

    @Override
    public <E> Flux<E> query(String sql, ResultWrapper<E, ?> wrapper) {
        log.trace("Execute ==> {}", (Object)sql);
        return ((WebClient.RequestBodySpec)this.client.post().uri("/rest/sql/" + this.database, new Object[0])).bodyValue((Object)sql).exchangeToFlux(response -> response.bodyToMono(String.class).flatMapMany(json -> {
            JSONObject result = JSON.parseObject((String)json);
            TDEngineUtils.checkExecuteResult(sql, result);
            return this.convertQueryResult(result, wrapper);
        }));
    }

    protected <E> Flux<E> convertQueryResult(JSONObject result, ResultWrapper<E, ?> wrapper) {
        JSONArray head = result.getJSONArray("column_meta");
        JSONArray data = result.getJSONArray("data");
        if (CollectionUtils.isEmpty((Collection)head) || CollectionUtils.isEmpty((Collection)data)) {
            return Flux.empty();
        }
        List columns = head.stream().map(v -> ((JSONArray)v).getString(0)).collect(Collectors.toList());
        return Flux.create(sink -> {
            wrapper.beforeWrap(() -> columns);
            for (Object rowo : data) {
                Object rowInstance = wrapper.newRowInstance();
                JSONArray row = (JSONArray)rowo;
                for (int i = 0; i < columns.size(); ++i) {
                    String property = (String)columns.get(i);
                    Object value = row.get(i);
                    DefaultColumnWrapperContext context = new DefaultColumnWrapperContext(i, property, value, rowInstance);
                    wrapper.wrapColumn((ColumnWrapperContext)context);
                    rowInstance = context.getRowInstance();
                }
                if (!wrapper.completedWrapRow(rowInstance)) break;
                if (rowInstance == null) continue;
                sink.next(rowInstance);
            }
            wrapper.completedWrap();
            sink.complete();
        });
    }

    public RestfulTDEngineQueryOperations(WebClient client, String database) {
        this.client = client;
        this.database = database;
    }
}

