/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.tdengine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.jetlinks.community.tdengine.TDengineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.publisher.Mono;

public class TDEngineUtils {
    private static final Logger log = LoggerFactory.getLogger(TDEngineUtils.class);

    public static Mono<JSONObject> checkExecuteResult(ClientResponse response) {
        if (response.statusCode().isError()) {
            return response.bodyToMono(String.class).doOnNext(str -> {
                throw new TDengineException(null, (String)str);
            }).switchIfEmpty(Mono.error(() -> new TDengineException(null, response.statusCode().getReasonPhrase()))).then(Mono.empty());
        }
        return response.bodyToMono(String.class).map(json -> {
            JSONObject obj = JSON.parseObject((String)json);
            TDEngineUtils.checkExecuteResult(null, obj);
            return obj;
        });
    }

    public static void checkExecuteResult(String sql, JSONObject result) {
        if (result.getInteger("code") != 0) {
            String error = result.getString("desc");
            if (sql != null && sql.startsWith("describe") && error.contains("does not exist")) {
                return;
            }
            if (sql != null) {
                log.warn("execute tdengine sql error [{}]: [{}]", (Object)error, (Object)sql);
            }
            throw new TDengineException(sql, result.getString("desc"));
        }
    }
}

