/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.tdengine;

import com.google.common.collect.Maps;
import java.util.Map;

public class Point {
    private String metric;
    private String table;
    private Map<String, Object> values = Maps.newLinkedHashMapWithExpectedSize((int)32);
    private Map<String, Object> tags = Maps.newLinkedHashMapWithExpectedSize((int)8);
    private long timestamp;

    public Point(String metric, String table) {
        this.metric = metric;
        this.table = table;
    }

    public static Point of(String metric, String table) {
        return new Point(metric, table);
    }

    public Point timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Point tag(String metric, Object value) {
        this.tags.put(metric, value);
        return this;
    }

    public Point tags(Map<String, Object> values) {
        this.tags.putAll(values);
        return this;
    }

    public Point value(String metric, Object value) {
        this.values.put(metric, value);
        return this;
    }

    public Point values(Map<String, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getTable() {
        return this.table;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setValues(Map<String, Object> values) {
        this.values = values;
    }

    public void setTags(Map<String, Object> tags) {
        this.tags = tags;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    private Point() {
    }
}

