/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.client;

import io.vertx.core.net.NetClientOptions;
import java.util.HashMap;
import java.util.Map;
import org.jetlinks.community.ValueObject;
import org.jetlinks.community.network.tcp.parser.PayloadParserType;

public class TcpClientProperties
implements ValueObject {
    private String id;
    private int port;
    private String host;
    private String certId;
    private boolean ssl;
    private PayloadParserType parserType = PayloadParserType.DIRECT;
    private Map<String, Object> parserConfiguration = new HashMap<String, Object>();
    private NetClientOptions options;
    private boolean enabled;

    public Map<String, Object> values() {
        return this.parserConfiguration;
    }

    public static TcpClientPropertiesBuilder builder() {
        return new TcpClientPropertiesBuilder();
    }

    public String getId() {
        return this.id;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getCertId() {
        return this.certId;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public PayloadParserType getParserType() {
        return this.parserType;
    }

    public Map<String, Object> getParserConfiguration() {
        return this.parserConfiguration;
    }

    public NetClientOptions getOptions() {
        return this.options;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setCertId(String certId) {
        this.certId = certId;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void setParserType(PayloadParserType parserType) {
        this.parserType = parserType;
    }

    public void setParserConfiguration(Map<String, Object> parserConfiguration) {
        this.parserConfiguration = parserConfiguration;
    }

    public void setOptions(NetClientOptions options) {
        this.options = options;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public TcpClientProperties() {
    }

    public TcpClientProperties(String id, int port, String host, String certId, boolean ssl, PayloadParserType parserType, Map<String, Object> parserConfiguration, NetClientOptions options, boolean enabled) {
        this.id = id;
        this.port = port;
        this.host = host;
        this.certId = certId;
        this.ssl = ssl;
        this.parserType = parserType;
        this.parserConfiguration = parserConfiguration;
        this.options = options;
        this.enabled = enabled;
    }

    public static class TcpClientPropertiesBuilder {
        private String id;
        private int port;
        private String host;
        private String certId;
        private boolean ssl;
        private PayloadParserType parserType;
        private Map<String, Object> parserConfiguration;
        private NetClientOptions options;
        private boolean enabled;

        TcpClientPropertiesBuilder() {
        }

        public TcpClientPropertiesBuilder id(String id) {
            this.id = id;
            return this;
        }

        public TcpClientPropertiesBuilder port(int port) {
            this.port = port;
            return this;
        }

        public TcpClientPropertiesBuilder host(String host) {
            this.host = host;
            return this;
        }

        public TcpClientPropertiesBuilder certId(String certId) {
            this.certId = certId;
            return this;
        }

        public TcpClientPropertiesBuilder ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public TcpClientPropertiesBuilder parserType(PayloadParserType parserType) {
            this.parserType = parserType;
            return this;
        }

        public TcpClientPropertiesBuilder parserConfiguration(Map<String, Object> parserConfiguration) {
            this.parserConfiguration = parserConfiguration;
            return this;
        }

        public TcpClientPropertiesBuilder options(NetClientOptions options) {
            this.options = options;
            return this;
        }

        public TcpClientPropertiesBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public TcpClientProperties build() {
            return new TcpClientProperties(this.id, this.port, this.host, this.certId, this.ssl, this.parserType, this.parserConfiguration, this.options, this.enabled);
        }

        public String toString() {
            return "TcpClientProperties.TcpClientPropertiesBuilder(id=" + this.id + ", port=" + this.port + ", host=" + this.host + ", certId=" + this.certId + ", ssl=" + this.ssl + ", parserType=" + (Object)((Object)this.parserType) + ", parserConfiguration=" + this.parserConfiguration + ", options=" + this.options + ", enabled=" + this.enabled + ")";
        }
    }
}

