/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.gateway.device;

import java.util.Objects;
import org.jetlinks.community.gateway.DeviceGateway;
import org.jetlinks.community.gateway.supports.DeviceGatewayProperties;
import org.jetlinks.community.gateway.supports.DeviceGatewayProvider;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.NetworkManager;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.tcp.gateway.device.TcpServerDeviceGateway;
import org.jetlinks.community.network.tcp.server.TcpServer;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.session.DeviceSessionManager;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.supports.server.DecodedClientMessageHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

@Component
public class TcpServerDeviceGatewayProvider
implements DeviceGatewayProvider {
    private final NetworkManager networkManager;
    private final DeviceRegistry registry;
    private final DeviceSessionManager sessionManager;
    private final DecodedClientMessageHandler messageHandler;
    private final ProtocolSupports protocolSupports;

    public TcpServerDeviceGatewayProvider(NetworkManager networkManager, DeviceRegistry registry, DeviceSessionManager sessionManager, DecodedClientMessageHandler messageHandler, ProtocolSupports protocolSupports) {
        this.networkManager = networkManager;
        this.registry = registry;
        this.sessionManager = sessionManager;
        this.messageHandler = messageHandler;
        this.protocolSupports = protocolSupports;
    }

    public String getId() {
        return "tcp-server-gateway";
    }

    public String getName() {
        return "TCP \u900f\u4f20\u63a5\u5165";
    }

    public NetworkType getNetworkType() {
        return DefaultNetworkType.TCP_SERVER;
    }

    public Transport getTransport() {
        return DefaultTransport.TCP;
    }

    public Mono<DeviceGateway> createDeviceGateway(DeviceGatewayProperties properties) {
        return this.networkManager.getNetwork(this.getNetworkType(), properties.getChannelId()).map(mqttServer -> {
            String protocol = properties.getProtocol();
            Assert.hasText((String)protocol, (String)"protocol can not be empty");
            return new TcpServerDeviceGateway(properties.getId(), (Mono<ProtocolSupport>)Mono.defer(() -> this.protocolSupports.getProtocol(protocol)), this.registry, this.messageHandler, this.sessionManager, (TcpServer)mqttServer);
        });
    }

    public Mono<? extends DeviceGateway> reloadDeviceGateway(DeviceGateway gateway, DeviceGatewayProperties properties) {
        TcpServerDeviceGateway deviceGateway = (TcpServerDeviceGateway)gateway;
        if (!Objects.equals(deviceGateway.tcpServer.getId(), properties.getChannelId())) {
            return gateway.shutdown().then(this.createDeviceGateway(properties)).flatMap(newer -> newer.startup().thenReturn(newer));
        }
        String protocol = properties.getProtocol();
        deviceGateway.protocol = Mono.defer(() -> this.protocolSupports.getProtocol(protocol));
        return Mono.just((Object)gateway);
    }
}

