/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.parser.strateies;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.parsetools.RecordParser;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetlinks.community.network.tcp.parser.PayloadParser;
import org.jetlinks.core.utils.Reactors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class PipePayloadParser
implements PayloadParser {
    private static final Logger log = LoggerFactory.getLogger(PipePayloadParser.class);
    private static final AtomicIntegerFieldUpdater<PipePayloadParser> CURRENT_PIPE = AtomicIntegerFieldUpdater.newUpdater(PipePayloadParser.class, "currentPipe");
    private final Sinks.Many<Buffer> sink = Reactors.createMany();
    private final List<BiConsumer<Buffer, PipePayloadParser>> pipe = new CopyOnWriteArrayList<BiConsumer<Buffer, PipePayloadParser>>();
    private final List<Buffer> result = new CopyOnWriteArrayList<Buffer>();
    private volatile RecordParser recordParser;
    private Function<Buffer, Buffer> directMapper;
    private Consumer<RecordParser> firstInit;
    private volatile int currentPipe;

    public Buffer newBuffer() {
        return Buffer.buffer();
    }

    public PipePayloadParser result(String buffer) {
        return this.result(Buffer.buffer((String)buffer));
    }

    public PipePayloadParser result(byte[] buffer) {
        return this.result(Buffer.buffer((byte[])buffer));
    }

    public PipePayloadParser handler(BiConsumer<Buffer, PipePayloadParser> handler) {
        this.pipe.add(handler);
        return this;
    }

    public PipePayloadParser delimited(String delimited) {
        if (this.recordParser == null) {
            this.setParser(RecordParser.newDelimited((String)delimited));
            this.firstInit = parser -> parser.delimitedMode(delimited);
            return this;
        }
        this.recordParser.delimitedMode(delimited);
        return this;
    }

    public PipePayloadParser fixed(int size) {
        if (size == 0) {
            this.complete();
            return this;
        }
        if (this.recordParser == null) {
            this.setParser(RecordParser.newFixed((int)size));
            this.firstInit = parser -> parser.fixedSizeMode(size);
            return this;
        }
        this.recordParser.fixedSizeMode(size);
        return this;
    }

    public PipePayloadParser direct(Function<Buffer, Buffer> mapper) {
        this.directMapper = mapper;
        return this;
    }

    private BiConsumer<Buffer, PipePayloadParser> getNextHandler() {
        int i = CURRENT_PIPE.getAndIncrement(this);
        if (i < this.pipe.size()) {
            return this.pipe.get(i);
        }
        CURRENT_PIPE.set(this, 0);
        return this.pipe.get(0);
    }

    private void setParser(RecordParser parser) {
        this.recordParser = parser;
        this.recordParser.handler(buffer -> this.getNextHandler().accept((Buffer)buffer, this));
    }

    public PipePayloadParser complete() {
        CURRENT_PIPE.set(this, 0);
        if (this.recordParser != null) {
            this.firstInit.accept(this.recordParser);
        }
        if (!this.result.isEmpty()) {
            Buffer buffer = Buffer.buffer();
            for (Buffer buf : this.result) {
                buffer.appendBuffer(buf);
            }
            this.result.clear();
            this.sink.emitNext((Object)buffer, Reactors.emitFailureHandler());
        }
        return this;
    }

    public PipePayloadParser result(Buffer buffer) {
        this.result.add(buffer);
        return this;
    }

    @Override
    public synchronized void handle(Buffer buffer) {
        if (this.recordParser == null && this.directMapper == null) {
            log.error("record parser not init");
            return;
        }
        if (this.recordParser != null) {
            this.recordParser.handle(buffer);
            return;
        }
        Buffer buf = this.directMapper.apply(buffer);
        if (null != buf) {
            this.sink.emitNext((Object)buf, Reactors.emitFailureHandler());
        }
    }

    @Override
    public Flux<Buffer> handlePayload() {
        return this.sink.asFlux();
    }

    @Override
    public void reset() {
        this.result.clear();
        this.complete();
    }

    @Override
    public void close() {
        this.sink.tryEmitComplete();
        CURRENT_PIPE.set(this, 0);
        this.result.clear();
    }
}

