/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.script;

import lombok.NonNull;

public class Script {
    @NonNull
    private final String name;
    @NonNull
    private final String content;
    private final Object source;

    public static Script of(String name, String content) {
        return Script.of(name, content, null);
    }

    public Script content(String content) {
        return Script.of(this.name, content, this.source);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getContent() {
        return this.content;
    }

    public Object getSource() {
        return this.source;
    }

    private Script(@NonNull String name, @NonNull String content, Object source) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.name = name;
        this.content = content;
        this.source = source;
    }

    public static Script of(@NonNull String name, @NonNull String content, Object source) {
        return new Script(name, content, source);
    }
}

