/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.api.crud.entity.RecordModifierEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.exception.BusinessException;
import org.jetlinks.community.rule.engine.enums.RuleInstanceState;
import org.jetlinks.community.rule.engine.scene.SceneAction;
import org.jetlinks.community.rule.engine.scene.SceneConditionAction;
import org.jetlinks.community.rule.engine.scene.SceneRule;
import org.jetlinks.community.rule.engine.scene.Trigger;
import org.jetlinks.community.rule.engine.scene.TriggerType;
import org.jetlinks.rule.engine.api.model.RuleModel;
import org.jetlinks.rule.engine.cluster.RuleInstance;

@Table(name="rule_scene")
@EnableEntityEvent
public class SceneEntity
extends GenericEntity<String>
implements RecordCreationEntity,
RecordModifierEntity {
    @Column(nullable=false)
    @Schema(description="\u544a\u8b66\u540d\u79f0")
    @NotBlank
    private String name;
    @Schema(description="\u89e6\u53d1\u5668\u7c7b\u578b")
    @Column(length=32, nullable=false, updatable=false)
    @EnumCodec
    @ColumnType(javaType=String.class)
    @NotNull
    private TriggerType triggerType;
    @Column
    @JsonCodec
    @ColumnType(javaType=String.class, jdbcType=JDBCType.LONGVARCHAR)
    @Schema(description="\u89e6\u53d1\u5668")
    @NotNull
    private Trigger trigger;
    @Column
    @JsonCodec
    @ColumnType(javaType=String.class, jdbcType=JDBCType.LONGVARCHAR)
    @Schema(description="\u89e6\u53d1\u6761\u4ef6")
    private List<Term> terms;
    @Column
    @Schema(description="\u662f\u5426\u5e76\u884c\u6267\u884c\u52a8\u4f5c")
    @DefaultValue(value="false")
    private Boolean parallel;
    @Column
    @JsonCodec
    @ColumnType(javaType=String.class, jdbcType=JDBCType.LONGVARCHAR)
    @Schema(description="\u6267\u884c\u52a8\u4f5c")
    private List<SceneAction> actions;
    @Column
    @JsonCodec
    @ColumnType(javaType=String.class, jdbcType=JDBCType.LONGVARCHAR)
    @Schema(description="\u52a8\u4f5c\u5206\u652f")
    private List<SceneConditionAction> branches;
    @Column(length=64, updatable=false)
    @Schema(description="\u521b\u5efa\u4eba")
    private String creatorId;
    @Column(updatable=false)
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    @DefaultValue(generator="current_time")
    private Long createTime;
    @Column(length=64)
    @Schema(description="\u4fee\u6539\u4eba")
    private String modifierId;
    @Column
    @Schema(description="\u4fee\u6539\u65f6\u95f4")
    @DefaultValue(generator="current_time")
    private Long modifyTime;
    @Column
    @Schema(description="\u542f\u52a8\u65f6\u95f4")
    private Long startTime;
    @Schema(description="\u72b6\u6001")
    @Column(length=32, nullable=false)
    @EnumCodec
    @ColumnType(javaType=String.class)
    @NotBlank
    @DefaultValue(value="disable")
    private RuleInstanceState state;
    @Schema(description="\u6269\u5c55\u914d\u7f6e")
    @Column(name="options")
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR)
    private Map<String, Object> options;
    @Column
    @Schema(description="\u8bf4\u660e")
    private String description;

    public RuleInstance toRule() {
        SceneRule rule = (SceneRule)this.copyTo(new SceneRule(), new String[0]);
        RuleInstance instance = new RuleInstance();
        instance.setId((String)this.getId());
        RuleModel model = rule.toModel();
        model.addConfiguration("creatorId", (Object)this.modifierId);
        model.addConfiguration("name", (Object)this.getName());
        instance.setModel(model);
        return instance;
    }

    public SceneEntity with(SceneRule rule) {
        SceneEntity entity = (SceneEntity)((Object)this.copyFrom(rule, new String[0]));
        entity.setTriggerType(rule.getTrigger().getType());
        return entity;
    }

    public void validate() {
        this.getTrigger().validate();
        if (CollectionUtils.isEmpty(this.getActions()) && CollectionUtils.isEmpty(this.getBranches())) {
            throw new BusinessException("error.scene_action_rule_cannot_be_null");
        }
    }

    public String getName() {
        return this.name;
    }

    @NotNull
    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    @NotNull
    public Trigger getTrigger() {
        return this.trigger;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public Boolean getParallel() {
        return this.parallel;
    }

    public List<SceneAction> getActions() {
        return this.actions;
    }

    public List<SceneConditionAction> getBranches() {
        return this.branches;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getModifierId() {
        return this.modifierId;
    }

    public Long getModifyTime() {
        return this.modifyTime;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public RuleInstanceState getState() {
        return this.state;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTriggerType(@NotNull TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public void setTrigger(@NotNull Trigger trigger) {
        this.trigger = trigger;
    }

    public void setTerms(List<Term> terms) {
        this.terms = terms;
    }

    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    public void setActions(List<SceneAction> actions) {
        this.actions = actions;
    }

    public void setBranches(List<SceneConditionAction> branches) {
        this.branches = branches;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setModifierId(String modifierId) {
        this.modifierId = modifierId;
    }

    public void setModifyTime(Long modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setState(RuleInstanceState state) {
        this.state = state;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

