/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.entity;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Table;
import javax.validation.constraints.Pattern;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import org.jetlinks.community.rule.engine.enums.RuleInstanceState;
import org.jetlinks.rule.engine.api.model.RuleEngineModelParser;
import org.jetlinks.rule.engine.api.model.RuleModel;
import org.jetlinks.rule.engine.cluster.RuleInstance;
import org.springframework.util.StringUtils;

@Table(name="rule_instance")
@Comment(value="\u89c4\u5219\u5b9e\u4f8b\u8868")
@EnableEntityEvent
public class RuleInstanceEntity
extends GenericEntity<String>
implements RecordCreationEntity {
    @Column(name="model_id", length=64)
    @Schema(description="\u6a21\u578bID")
    private String modelId;
    @Column(name="name")
    @Schema(description="\u540d\u79f0")
    private String name;
    @Column(name="description")
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Column(name="model_type")
    @Schema(description="\u89c4\u5219\u7c7b\u578b")
    private String modelType;
    @Column(name="model_meta")
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR)
    @Schema(description="\u89c4\u5219\u6a21\u578b\u914d\u7f6e,\u4e0d\u540c\u7684\u7c7b\u578b\u914d\u7f6e\u4e0d\u540c.")
    private String modelMeta;
    @Column(name="model_version", nullable=false)
    @Schema(description="\u7248\u672c")
    @DefaultValue(value="1")
    private Integer modelVersion;
    @Column(name="create_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    @DefaultValue(generator="current_time")
    private Long createTime;
    @Column(name="creator_id")
    @Schema(description="\u521b\u5efa\u8005ID")
    private String creatorId;
    @Column(name="state", length=16)
    @EnumCodec
    @ColumnType(javaType=String.class)
    @DefaultValue(value="disable")
    @Schema(description="\u72b6\u6001")
    private RuleInstanceState state;
    @Comment(value="\u8bbe\u5907\u8be6\u60c5\u4fe1\u606f")
    @Column(name="instance_detail_json")
    @ColumnType(jdbcType=JDBCType.CLOB)
    @Hidden
    private String instanceDetailJson;

    @GeneratedValue(generator="snow_flake")
    @Pattern(regexp="^[0-9a-zA-Z_\\-]+$", message="ID\u53ea\u80fd\u7531\u6570\u5b57,\u5b57\u6bcd,\u4e0b\u5212\u7ebf\u548c\u4e2d\u5212\u7ebf\u7ec4\u6210", groups={CreateGroup.class})
    @Schema(description="ID")
    public @Pattern(regexp="^[0-9a-zA-Z_\\-]+$", message="ID\u53ea\u80fd\u7531\u6570\u5b57,\u5b57\u6bcd,\u4e0b\u5212\u7ebf\u548c\u4e2d\u5212\u7ebf\u7ec4\u6210", groups={CreateGroup.class}) String getId() {
        return (String)super.getId();
    }

    public RuleModel toRule(RuleEngineModelParser parser) {
        RuleModel model = parser.parse(this.modelType, this.modelMeta);
        model.setId(StringUtils.hasText((String)this.modelId) ? this.modelId : this.getId());
        model.setName(this.name);
        model.addConfiguration("creatorId", (Object)this.creatorId);
        return model;
    }

    public RuleInstance toRuleInstance(RuleEngineModelParser parser) {
        RuleModel model = this.toRule(parser);
        RuleInstance instance = new RuleInstance();
        instance.setId(this.getId());
        instance.setModel(model);
        return instance;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModelType() {
        return this.modelType;
    }

    public String getModelMeta() {
        return this.modelMeta;
    }

    public Integer getModelVersion() {
        return this.modelVersion;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public RuleInstanceState getState() {
        return this.state;
    }

    public String getInstanceDetailJson() {
        return this.instanceDetailJson;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    public void setModelMeta(String modelMeta) {
        this.modelMeta = modelMeta;
    }

    public void setModelVersion(Integer modelVersion) {
        this.modelVersion = modelVersion;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setState(RuleInstanceState state) {
        this.state = state;
    }

    public void setInstanceDetailJson(String instanceDetailJson) {
        this.instanceDetailJson = instanceDetailJson;
    }
}

