/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.things.relation.ObjectType;
import org.jetlinks.core.things.relation.Relation;
import org.jetlinks.core.utils.SerializeUtils;

public class SimpleObjectType
implements ObjectType,
Externalizable {
    private String id;
    private String name;
    private String description;
    private Map<String, Object> expands;
    private Map<String, List<Relation>> relations;
    private List<ObjectType> relatedTypes;
    private List<PropertyMetadata> properties;

    public SimpleObjectType() {
    }

    public SimpleObjectType(ObjectType type) {
        this(type.getId(), type.getName(), type.getDescription());
        this.expands = type.getExpands();
        this.relations = type.getRelations();
        this.properties = type.getProperties();
        this.relatedTypes = type.getRelatedTypes();
    }

    public SimpleObjectType(String id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public static SimpleObjectType of(ObjectType type) {
        if (type instanceof SimpleObjectType) {
            return (SimpleObjectType)type;
        }
        return new SimpleObjectType(type);
    }

    public List<Relation> getRelations(String type) {
        if (this.relations == null) {
            return Collections.emptyList();
        }
        return this.relations.getOrDefault(type, Collections.emptyList());
    }

    public SimpleObjectType withExpands(Map<String, Object> expands) {
        if (this.expands == null) {
            this.expands = new HashMap<String, Object>();
        }
        this.expands.putAll(expands);
        return this;
    }

    public SimpleObjectType withExpand(String key, String value) {
        if (this.expands == null) {
            this.expands = new HashMap<String, Object>();
        }
        this.expands.put(key, value);
        return this;
    }

    public SimpleObjectType withRelation(String type, List<? extends Relation> relation) {
        if (this.relations == null) {
            this.relations = new HashMap<String, List<Relation>>();
        }
        this.relations.computeIfAbsent(type, ignore -> new ArrayList()).addAll(relation);
        return this;
    }

    public SimpleObjectType withProperty(String id, String name, DataType type) {
        return this.withProperty((PropertyMetadata)SimplePropertyMetadata.of((String)id, (String)name, (DataType)type));
    }

    public Map<String, List<Relation>> getRelations() {
        return Collections.unmodifiableMap(this.relations);
    }

    public SimpleObjectType withProperty(PropertyMetadata property) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyMetadata>();
        }
        this.properties.add(property);
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeObject((Object)this.id, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.name, (ObjectOutput)out);
        SerializeUtils.writeObject((Object)this.description, (ObjectOutput)out);
        SerializeUtils.writeObject(this.expands, (ObjectOutput)out);
        SerializeUtils.writeObject(this.relations, (ObjectOutput)out);
        List<Object> relatedTypes = this.relatedTypes;
        if (relatedTypes != null) {
            relatedTypes = relatedTypes.stream().map(SimpleObjectType::of).collect(Collectors.toList());
        }
        SerializeUtils.writeObject(relatedTypes, (ObjectOutput)out);
        SerializeUtils.writeObject(this.properties, (ObjectOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (String)SerializeUtils.readObject((ObjectInput)in);
        this.name = (String)SerializeUtils.readObject((ObjectInput)in);
        this.description = (String)SerializeUtils.readObject((ObjectInput)in);
        this.expands = (Map)SerializeUtils.readObject((ObjectInput)in);
        this.relations = (Map)SerializeUtils.readObject((ObjectInput)in);
        this.relatedTypes = (List)SerializeUtils.readObject((ObjectInput)in);
        this.properties = (List)SerializeUtils.readObject((ObjectInput)in);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getExpands() {
        return this.expands;
    }

    public List<ObjectType> getRelatedTypes() {
        return this.relatedTypes;
    }

    public List<PropertyMetadata> getProperties() {
        return this.properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }

    public void setRelations(Map<String, List<Relation>> relations) {
        this.relations = relations;
    }

    public void setRelatedTypes(List<ObjectType> relatedTypes) {
        this.relatedTypes = relatedTypes;
    }

    public void setProperties(List<PropertyMetadata> properties) {
        this.properties = properties;
    }
}

