/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.utils.DigestUtils;
import org.hswebframework.web.validator.CreateGroup;
import org.jetlinks.community.relation.service.RelatedObjectInfo;
import org.springframework.util.StringUtils;

@Table(name="s_object_related", indexes={@Index(name="idx_rel_obj_key", columnList="object_key"), @Index(name="idx_rel_obj_t_id", columnList="object_type,object_id"), @Index(name="idx_rel_rel_key", columnList="related_key"), @Index(name="idx_rel_relation", columnList="relation")})
@EnableEntityEvent
public class RelatedEntity
extends GenericEntity<String> {
    @Schema(description="\u5bf9\u8c61\u7c7b\u578b", accessMode=Schema.AccessMode.READ_ONLY)
    @Column(length=32, nullable=false, updatable=false)
    @NotBlank(groups={CreateGroup.class})
    private String objectType;
    @Schema(description="\u5bf9\u8c61ID", accessMode=Schema.AccessMode.READ_ONLY)
    @Column(length=64, nullable=false, updatable=false)
    @NotBlank(groups={CreateGroup.class})
    private String objectId;
    @Schema(description="\u5bf9\u8c61KEY,md5(type+|+id)", accessMode=Schema.AccessMode.READ_ONLY)
    @Column(length=64, nullable=false, updatable=false)
    @NotBlank(groups={CreateGroup.class})
    private String objectKey;
    @Column(length=64)
    @Schema(description="\u5bf9\u8c61\u540d\u79f0")
    private String objectName;
    @Schema(description="\u76ee\u6807\u5173\u7cfb\u5bf9\u8c61\u7c7b\u578b")
    @Column(length=32, nullable=false)
    @NotBlank(groups={CreateGroup.class})
    private String relatedType;
    @Schema(description="\u76ee\u6807\u5173\u7cfb\u5bf9\u8c61ID")
    @Column(length=64, nullable=false)
    @NotBlank(groups={CreateGroup.class})
    private String relatedId;
    @Schema(description="\u76ee\u6807\u5173\u7cfb\u540d\u79f0")
    @Column(length=64)
    private String relatedName;
    @Schema(description="\u76ee\u6807\u5173\u7cfb\u5bf9\u8c61KEY,md5(type+|+id)", accessMode=Schema.AccessMode.READ_ONLY)
    @Column(length=64, nullable=false)
    @NotBlank(groups={CreateGroup.class})
    private String relatedKey;
    @Schema(description="\u5173\u7cfb")
    @Column(length=32, nullable=false, updatable=false)
    @NotBlank(groups={CreateGroup.class})
    private String relation;
    @Column
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    @DefaultValue(generator="current_time")
    private Long createTime;

    public String getObjectKey() {
        if (!StringUtils.hasText((String)this.objectKey) && StringUtils.hasText((String)this.objectType) && StringUtils.hasText((String)this.objectId)) {
            this.objectKey = RelatedEntity.generateKey(this.objectType, this.objectId);
        }
        return this.objectKey;
    }

    public String getRelatedKey() {
        if (!StringUtils.hasText((String)this.relatedKey) && StringUtils.hasText((String)this.relatedType) && StringUtils.hasText((String)this.relatedId)) {
            this.relatedKey = RelatedEntity.generateKey(this.relatedType, this.relatedId);
        }
        return this.relatedKey;
    }

    public RelatedEntity withObject(String type, String id) {
        this.setObjectId(id);
        this.setObjectType(type);
        this.getObjectKey();
        return this;
    }

    public RelatedEntity withRelated(String type, RelatedObjectInfo info, String relation) {
        this.setRelatedId(info.getId());
        this.setRelatedName(info.getName());
        this.setRelatedType(type);
        this.setRelation(relation);
        this.getRelatedKey();
        return this;
    }

    public static String generateKey(String ... keys) {
        return DigestUtils.md5Hex((String)String.join((CharSequence)"|", keys));
    }

    public static Set<String> generateKey(String type, Collection<String> idList) {
        return idList.stream().map(id -> RelatedEntity.generateKey(type, id)).collect(Collectors.toSet());
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getRelatedType() {
        return this.relatedType;
    }

    public String getRelatedId() {
        return this.relatedId;
    }

    public String getRelatedName() {
        return this.relatedName;
    }

    public String getRelation() {
        return this.relation;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setRelatedType(String relatedType) {
        this.relatedType = relatedType;
    }

    public void setRelatedId(String relatedId) {
        this.relatedId = relatedId;
    }

    public void setRelatedName(String relatedName) {
        this.relatedName = relatedName;
    }

    public void setRelatedKey(String relatedKey) {
        this.relatedKey = relatedKey;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }
}

