/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.protocol.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import lombok.Generated;
import org.jetlinks.community.ValueObject;
import org.jetlinks.community.protocol.local.LocalFileProtocolSupport;
import org.jetlinks.core.spi.ServiceContext;
import org.jetlinks.supports.protocol.management.ProtocolSupportDefinition;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoaderProvider;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Generated
public class LocalProtocolSupportLoader
implements ProtocolSupportLoaderProvider {
    private final ServiceContext serviceContext;

    public String getProvider() {
        return "local";
    }

    public Mono<LocalFileProtocolSupport> load(ProtocolSupportDefinition definition) {
        return Mono.fromCallable(() -> {
            ValueObject config = ValueObject.of((Map)definition.getConfiguration());
            String location = (String)config.getString("location").orElseThrow(() -> new IllegalArgumentException("location cannot be null"));
            String provider = config.get("provider").map(String::valueOf).map(String::trim).orElse(null);
            File file = new File(location);
            if (!file.exists()) {
                throw new FileNotFoundException("\u6587\u4ef6" + file.getName() + "\u4e0d\u5b58\u5728");
            }
            LocalFileProtocolSupport support = new LocalFileProtocolSupport();
            support.init(file, this.serviceContext, provider);
            return support;
        }).subscribeOn(Schedulers.boundedElastic());
    }

    public LocalProtocolSupportLoader(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }
}

