/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.protocol.local;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.net.URL;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.device.AuthenticationRequest;
import org.jetlinks.core.device.AuthenticationResponse;
import org.jetlinks.core.device.DeviceInfo;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.DeviceStateChecker;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.message.interceptor.DeviceMessageSenderInterceptor;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.DeviceMetadataCodec;
import org.jetlinks.core.metadata.DeviceMetadataType;
import org.jetlinks.core.metadata.Feature;
import org.jetlinks.core.route.Route;
import org.jetlinks.core.server.ClientConnection;
import org.jetlinks.core.server.DeviceGatewayContext;
import org.jetlinks.core.spi.ProtocolSupportProvider;
import org.jetlinks.core.spi.ServiceContext;
import org.jetlinks.core.utils.ClassUtils;
import org.jetlinks.supports.protocol.management.jar.ProtocolClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Generated
public class LocalFileProtocolSupport
implements ProtocolSupport {
    private static final Logger log = LoggerFactory.getLogger(LocalFileProtocolSupport.class);
    private volatile ProtocolSupport loaded;
    private final Disposable.Composite disposable = Disposables.composite();

    protected void closeClassLoader(ProtocolClassLoader loader) {
        if (null != loader) {
            loader.close();
        }
    }

    public void init(File file, ServiceContext context, String providerName) {
        String path = file.isDirectory() ? file.getAbsolutePath() : file.getParentFile().getAbsolutePath();
        final WatchService watchService = FileSystems.getDefault().newWatchService();
        Consumer<Path> doWatch = watch -> {
            try {
                WatchKey key = watch.register(watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH);
                this.disposable.add(key::cancel);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        Files.walk(Paths.get(path, new String[0]), FileVisitOption.FOLLOW_LINKS).filter(p -> p.toFile().isDirectory()).forEach(doWatch);
        final AtomicReference ref = new AtomicReference();
        this.disposable.add(new Disposable(){

            @Generated
            public void dispose() {
                watchService.close();
                LocalFileProtocolSupport.this.closeClassLoader((ProtocolClassLoader)ref.get());
            }
        });
        URL[] urls = new URL[]{file.toURI().toURL()};
        Callable<Object> init = () -> {
            log.debug("{}load local protocol :{}", (Object)(ref.get() == null ? "" : "re"), (Object)file);
            ProtocolClassLoader loader = new ProtocolClassLoader(urls, org.springframework.util.ClassUtils.getDefaultClassLoader());
            ProtocolSupportProvider supportProvider = StringUtils.hasText((String)providerName) ? (ProtocolSupportProvider)Class.forName(providerName, true, (ClassLoader)loader).newInstance() : (ProtocolSupportProvider)ClassUtils.findImplClass(ProtocolSupportProvider.class, (String)"**/*.class", (ClassLoader)loader, ProtocolClassLoader::loadSelfClass).orElseThrow(() -> new IllegalArgumentException("ProtocolSupportProvider not found"));
            this.disposable.add((Disposable)supportProvider);
            supportProvider.create(context).subscribe(protocol -> {
                log.debug("{}load local protocol :{}", (Object)(ref.get() == null ? "" : "re"), protocol);
                this.closeClassLoader((ProtocolClassLoader)ref.get());
                ref.set(loader);
                if (this.loaded != null) {
                    this.loaded.dispose();
                }
                this.loaded = protocol;
            }, error -> {
                log.error("init local protocol error", error);
                supportProvider.dispose();
                this.closeClassLoader(loader);
            });
            return null;
        };
        init.call();
        this.disposable.add(Flux.create(sink -> {
            while (!this.isDisposed()) {
                try {
                    WatchKey watchKey = watchService.take();
                    if (watchKey == null) continue;
                    watchKey.pollEvents();
                    sink.next((Object)watchKey);
                    watchKey.reset();
                }
                catch (InterruptedException | ClosedWatchServiceException e) {
                    break;
                }
                catch (Exception e) {
                    log.error("init local protocol error", (Throwable)e);
                }
            }
        }).elapsed().window(Duration.ofSeconds(2L)).flatMap(window -> window.takeLast(1)).delayElements(Duration.ofSeconds(1L)).doOnNext(tp2 -> {
            try {
                init.call();
            }
            catch (Exception e) {
                log.error("init local protocol error", (Throwable)e);
            }
        }).subscribeOn(Schedulers.boundedElastic()).subscribe());
    }

    @Nonnull
    public String getId() {
        return this.loaded.getId();
    }

    public String getName() {
        return this.loaded.getName();
    }

    public String getDescription() {
        return this.loaded.getDescription();
    }

    public Flux<? extends Transport> getSupportedTransport() {
        return this.loaded.getSupportedTransport();
    }

    @Nonnull
    public Mono<? extends DeviceMessageCodec> getMessageCodec(Transport transport) {
        return this.loaded.getMessageCodec(transport);
    }

    @Nonnull
    public DeviceMetadataCodec getMetadataCodec() {
        return this.loaded.getMetadataCodec();
    }

    @Nonnull
    public Mono<AuthenticationResponse> authenticate(@Nonnull AuthenticationRequest request, @Nonnull DeviceOperator deviceOperation) {
        return this.loaded.authenticate(request, deviceOperation);
    }

    @Nonnull
    public Mono<AuthenticationResponse> authenticate(@Nonnull AuthenticationRequest request, @Nonnull DeviceRegistry registry) {
        return this.loaded.authenticate(request, registry);
    }

    public Flux<DeviceMetadataCodec> getMetadataCodecs() {
        return this.loaded.getMetadataCodecs();
    }

    public Mono<ConfigMetadata> getConfigMetadata(Transport transport) {
        return this.loaded.getConfigMetadata(transport);
    }

    public Mono<ConfigMetadata> getInitConfigMetadata() {
        return this.loaded.getInitConfigMetadata();
    }

    public Mono<DeviceMessageSenderInterceptor> getSenderInterceptor() {
        return this.loaded.getSenderInterceptor();
    }

    @Nonnull
    public Mono<DeviceStateChecker> getStateChecker() {
        return this.loaded.getStateChecker();
    }

    public Flux<ConfigMetadata> getMetadataExpandsConfig(Transport transport, DeviceMetadataType metadataType, String metadataId, String dataTypeId) {
        return this.loaded.getMetadataExpandsConfig(transport, metadataType, metadataId, dataTypeId);
    }

    public Mono<Void> onProductRegister(DeviceProductOperator operator) {
        return this.loaded.onProductRegister(operator);
    }

    public Mono<Void> onDeviceRegister(DeviceOperator operator) {
        return this.loaded.onDeviceRegister(operator);
    }

    public Mono<Void> onDeviceUnRegister(DeviceOperator operator) {
        return this.loaded.onDeviceUnRegister(operator);
    }

    public Mono<Void> onProductUnRegister(DeviceProductOperator operator) {
        return this.loaded.onProductUnRegister(operator);
    }

    public Mono<DeviceMetadata> getDefaultMetadata(Transport transport) {
        return this.loaded.getDefaultMetadata(transport);
    }

    public Mono<Void> onDeviceMetadataChanged(DeviceOperator operator) {
        return this.loaded.onDeviceMetadataChanged(operator);
    }

    public Mono<Void> onProductMetadataChanged(DeviceProductOperator operator) {
        return this.loaded.onProductMetadataChanged(operator);
    }

    public void dispose() {
        if (this.loaded != null) {
            this.loaded.dispose();
        }
        this.disposable.dispose();
    }

    public boolean isDisposed() {
        return this.disposable.isDisposed();
    }

    public Mono<Void> onChildBind(DeviceOperator gateway, Flux<DeviceOperator> child) {
        return this.loaded.onChildBind(gateway, child);
    }

    public Mono<Void> onChildUnbind(DeviceOperator gateway, Flux<DeviceOperator> child) {
        return this.loaded.onChildUnbind(gateway, child);
    }

    public Mono<Void> onClientConnect(Transport transport, ClientConnection connection, DeviceGatewayContext context) {
        return this.loaded.onClientConnect(transport, connection, context);
    }

    public Flux<Feature> getFeatures(Transport transport) {
        return this.loaded.getFeatures(transport);
    }

    public Mono<DeviceInfo> doBeforeDeviceCreate(Transport transport, DeviceInfo deviceInfo) {
        return this.loaded.doBeforeDeviceCreate(transport, deviceInfo);
    }

    public int getOrder() {
        return this.loaded.getOrder();
    }

    public int compareTo(ProtocolSupport o) {
        return this.loaded.compareTo(o);
    }

    public Flux<Route> getRoutes(Transport transport) {
        return this.loaded.getRoutes(transport);
    }

    public String getDocument(Transport transport) {
        return this.loaded.getDocument(transport);
    }

    public boolean isEmbedded() {
        return this.loaded.isEmbedded();
    }
}

