/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.entity;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.notify.manager.entity.Notification;
import org.jetlinks.community.notify.manager.enums.NotificationState;

@Table(name="notify_notifications", indexes={@Index(name="idx_ntfc_subscribe", columnList="subscriber_type,subscriber")})
public class NotificationEntity
extends GenericEntity<String> {
    private static final long serialVersionUID = -1L;
    @Column(length=64, nullable=false, updatable=false)
    @Hidden
    private String subscribeId;
    @Column(length=32, nullable=false, updatable=false)
    @Hidden
    private String subscriberType;
    @Column(length=64, nullable=false, updatable=false)
    @Hidden
    private String subscriber;
    @Column(length=32, nullable=false, updatable=false)
    @Schema(description="\u4e3b\u9898\u6807\u8bc6,\u5982:device_alarm")
    private String topicProvider;
    @Column(length=64, nullable=false, updatable=false)
    @Schema(description="\u4e3b\u9898\u540d\u79f0")
    private String topicName;
    @Column
    @ColumnType(jdbcType=JDBCType.CLOB, javaType=String.class)
    @Schema(description="\u901a\u77e5\u6d88\u606f")
    private String message;
    @Column(length=64)
    @Schema(description="\u6570\u636eID")
    private String dataId;
    @Column(nullable=false)
    @Schema(description="\u901a\u77e5\u65f6\u95f4")
    private Long notifyTime;
    @Column(length=32)
    @EnumCodec
    @DefaultValue(value="unread")
    @ColumnType(javaType=String.class)
    @Schema(description="\u901a\u77e5\u72b6\u6001")
    private NotificationState state;
    @Column(length=1024)
    @Schema(description="\u8bf4\u660e")
    private String description;

    public static NotificationEntity from(Notification notification) {
        return (NotificationEntity)((Object)FastBeanCopier.copy((Object)notification, (Object)((Object)new NotificationEntity()), (String[])new String[0]));
    }

    public String getSubscribeId() {
        return this.subscribeId;
    }

    public String getSubscriberType() {
        return this.subscriberType;
    }

    public String getSubscriber() {
        return this.subscriber;
    }

    public String getTopicProvider() {
        return this.topicProvider;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDataId() {
        return this.dataId;
    }

    public Long getNotifyTime() {
        return this.notifyTime;
    }

    public NotificationState getState() {
        return this.state;
    }

    public String getDescription() {
        return this.description;
    }

    public void setSubscribeId(String subscribeId) {
        this.subscribeId = subscribeId;
    }

    public void setSubscriberType(String subscriberType) {
        this.subscriberType = subscriberType;
    }

    public void setSubscriber(String subscriber) {
        this.subscriber = subscriber;
    }

    public void setTopicProvider(String topicProvider) {
        this.topicProvider = topicProvider;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public void setNotifyTime(Long notifyTime) {
        this.notifyTime = notifyTime;
    }

    public void setState(NotificationState state) {
        this.state = state;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

