/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.entity;

import java.io.Serializable;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.community.notify.manager.entity.NotifySubscriberEntity;
import org.jetlinks.community.notify.manager.subscriber.Notify;

public class Notification
implements Serializable {
    private static final long serialVersionUID = -1L;
    private String id;
    private String subscribeId;
    private String subscriberType;
    private String subscriber;
    private String topicProvider;
    private String topicName;
    private String message;
    private String dataId;
    private long notifyTime;

    public static Notification from(NotifySubscriberEntity entity) {
        Notification notification = new Notification();
        notification.subscribeId = (String)entity.getId();
        notification.subscriberType = entity.getSubscriberType();
        notification.subscriber = entity.getSubscriber();
        notification.topicName = entity.getTopicName();
        notification.setTopicProvider(entity.getTopicProvider());
        return notification;
    }

    public Notification copyWithMessage(Notify message) {
        Notification target = (Notification)FastBeanCopier.copy((Object)this, (Object)new Notification(), (String[])new String[0]);
        target.setId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        target.setMessage(message.getMessage());
        target.setDataId(message.getDataId());
        target.setNotifyTime(message.getNotifyTime());
        return target;
    }

    public String createTopic() {
        return "/notifications/" + this.getSubscriberType() + "/" + this.getSubscriber() + "/" + this.getTopicProvider() + "/" + this.getSubscribeId();
    }

    public String getId() {
        return this.id;
    }

    public String getSubscribeId() {
        return this.subscribeId;
    }

    public String getSubscriberType() {
        return this.subscriberType;
    }

    public String getSubscriber() {
        return this.subscriber;
    }

    public String getTopicProvider() {
        return this.topicProvider;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDataId() {
        return this.dataId;
    }

    public long getNotifyTime() {
        return this.notifyTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSubscribeId(String subscribeId) {
        this.subscribeId = subscribeId;
    }

    public void setSubscriberType(String subscriberType) {
        this.subscriberType = subscriberType;
    }

    public void setSubscriber(String subscriber) {
        this.subscriber = subscriber;
    }

    public void setTopicProvider(String topicProvider) {
        this.topicProvider = topicProvider;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public void setNotifyTime(long notifyTime) {
        this.notifyTime = notifyTime;
    }
}

