/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.email.embedded;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.apache.commons.codec.binary.Base64;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.validator.ValidatorUtils;
import org.jetlinks.community.io.file.FileManager;
import org.jetlinks.community.notify.AbstractNotifier;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.email.EmailProvider;
import org.jetlinks.community.notify.email.embedded.DefaultEmailProperties;
import org.jetlinks.community.notify.email.embedded.EmailTemplate;
import org.jetlinks.community.notify.email.embedded.ParsedEmailTemplate;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.core.Values;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.http.MediaType;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class DefaultEmailNotifier
extends AbstractNotifier<EmailTemplate> {
    private static final Logger log = LoggerFactory.getLogger(DefaultEmailNotifier.class);
    private JavaMailSender javaMailSender;
    private String sender;
    private final String notifierId;
    private boolean enableFileSystemAttachment = Boolean.getBoolean("email.attach.local-file.enabled");
    public static Scheduler scheduler = Schedulers.boundedElastic();
    private final FileManager fileManager;

    public DefaultEmailNotifier(NotifierProperties properties, TemplateManager templateManager, FileManager fileManager) {
        this(properties.getId(), (DefaultEmailProperties)FastBeanCopier.copy((Object)properties.getConfiguration(), (Object)new DefaultEmailProperties(), (String[])new String[0]), templateManager, fileManager);
    }

    public DefaultEmailNotifier(String id, DefaultEmailProperties properties, TemplateManager templateManager, FileManager fileManager) {
        super(templateManager);
        ValidatorUtils.tryValidate((Object)properties, (Class[])new Class[0]);
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(properties.getHost());
        mailSender.setPort(properties.getPort());
        mailSender.setUsername(properties.getUsername());
        mailSender.setPassword(properties.getPassword());
        mailSender.setJavaMailProperties(properties.createJavaMailProperties());
        this.notifierId = id;
        this.sender = properties.getSender();
        this.javaMailSender = mailSender;
        this.fileManager = fileManager;
    }

    @Nonnull
    public Mono<Void> send(@Nonnull EmailTemplate template, @Nonnull Values context) {
        return Mono.just((Object)((Object)template)).flatMap(temp -> DefaultEmailNotifier.convert(temp, context.getAllValues())).flatMap(this::doSend);
    }

    @Nonnull
    public Mono<Void> close() {
        return Mono.empty();
    }

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.email;
    }

    @Nonnull
    public Provider getProvider() {
        return EmailProvider.embedded;
    }

    protected Mono<Void> doSend(ParsedEmailTemplate template) {
        return Mono.fromCallable(() -> {
            MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "utf-8");
            helper.setFrom(this.sender);
            helper.setTo(template.getSendTo().toArray(new String[0]));
            helper.setSubject(template.getSubject());
            helper.setText(new String(template.getText().getBytes(), StandardCharsets.UTF_8), true);
            return Flux.fromIterable(template.getAttachments().entrySet()).flatMap(entry -> Mono.zip((Mono)Mono.just(entry.getKey()), this.convertResource((String)entry.getValue()))).flatMap(tp2 -> Mono.fromCallable(() -> {
                helper.addAttachment(MimeUtility.encodeText((String)((String)tp2.getT1())), (InputStreamSource)tp2.getT2());
                return helper;
            })).then(Flux.fromIterable(template.getImages().entrySet()).flatMap(entry -> Mono.zip((Mono)Mono.just(entry.getKey()), this.convertResource((String)entry.getValue()))).flatMap(tp2 -> Mono.fromCallable(() -> {
                helper.addInline((String)tp2.getT1(), (InputStreamSource)tp2.getT2(), "application/octet-stream");
                return helper;
            })).then()).thenReturn((Object)mimeMessage);
        }).flatMap(Function.identity()).doOnNext(message -> this.javaMailSender.send(message)).subscribeOn(scheduler).then();
    }

    protected Mono<? extends InputStreamSource> convertResource(String resource) {
        if (resource.startsWith("http")) {
            return WebClient.create().get().uri(resource, new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM}).exchangeToMono(res -> res.bodyToMono(Resource.class));
        }
        if (resource.startsWith("data:") && resource.contains(";base64,")) {
            String base64 = resource.substring(resource.indexOf(";base64,") + 8);
            return Mono.just((Object)new ByteArrayResource(Base64.decodeBase64((String)base64)));
        }
        if (this.enableFileSystemAttachment && resource.contains("/")) {
            return Mono.just((Object)new FileSystemResource(resource));
        }
        return ((Mono)this.fileManager.read(resource).as(DataBufferUtils::join)).map(dataBuffer -> {
            try {
                ByteBuf buf = dataBuffer instanceof NettyDataBuffer ? ((NettyDataBuffer)dataBuffer).getNativeBuffer() : Unpooled.wrappedBuffer((ByteBuffer)dataBuffer.asByteBuffer());
                ByteArrayResource byteArrayResource = new ByteArrayResource(ByteBufUtil.getBytes((ByteBuf)buf));
                return byteArrayResource;
            }
            finally {
                DataBufferUtils.release((DataBuffer)dataBuffer);
            }
        }).onErrorMap(error -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u5730\u5740:" + resource, (Throwable)error)).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u5730\u5740:" + resource)));
    }

    public static Mono<ParsedEmailTemplate> convert(EmailTemplate template, Map<String, Object> context) {
        return template.getSendTo(context).flatMapMany(Flux::fromIterable).map(receiver -> template.render((String)receiver, context)).collectList().map(sendToList -> {
            String subject = template.getSubject();
            String text = template.getText();
            if (CollectionUtils.isEmpty((Collection)sendToList) || ObjectUtils.isEmpty((Object)subject) || ObjectUtils.isEmpty((Object)text)) {
                throw new BusinessException("\u6a21\u677f\u5185\u5bb9\u9519\u8bef\uff0csendTo, text \u6216\u8005 subject \u4e0d\u80fd\u4e3a\u7a7a.");
            }
            String sendText = template.render(text, context);
            List<EmailTemplate.Attachment> tempAttachments = template.getAttachments();
            LinkedHashMap<String, String> attachments = new LinkedHashMap<String, String>();
            if (tempAttachments != null) {
                int index = 0;
                for (EmailTemplate.Attachment tempAttachment : tempAttachments) {
                    String name = template.render(tempAttachment.getName(), context);
                    String location = template.get(tempAttachment.getLocation(), EmailTemplate.Attachment.locationKey(++index), context);
                    attachments.put(name, location);
                }
            }
            HashMap<String, String> images = new HashMap<String, String>();
            sendText = DefaultEmailNotifier.extractSendTextImage(sendText, images);
            return ParsedEmailTemplate.builder().attachments(attachments).images(images).text(sendText).subject(template.render(subject, context)).sendTo((List<String>)sendToList).build();
        });
    }

    private static String extractSendTextImage(String sendText, Map<String, String> images) {
        if (!sendText.contains("<")) {
            return sendText;
        }
        boolean anyImage = false;
        Document doc = Jsoup.parse((String)sendText);
        for (Element src : doc.getElementsByTag("img")) {
            String s = src.attr("src");
            if (s.startsWith("http")) continue;
            anyImage = true;
            String tempKey = (String)IDGenerator.MD5.generate();
            src.attr("src", "cid:".concat(tempKey));
            images.put(tempKey, s);
        }
        return anyImage ? doc.html() : sendText;
    }

    public JavaMailSender getJavaMailSender() {
        return this.javaMailSender;
    }

    public void setJavaMailSender(JavaMailSender javaMailSender) {
        this.javaMailSender = javaMailSender;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getNotifierId() {
        return this.notifierId;
    }

    public void setEnableFileSystemAttachment(boolean enableFileSystemAttachment) {
        this.enableFileSystemAttachment = enableFileSystemAttachment;
    }
}

