/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.email.embedded;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetlinks.community.notify.template.AbstractTemplate;
import org.jetlinks.community.notify.template.VariableDefinition;
import org.jetlinks.community.relation.RelationConstants;
import org.jetlinks.community.relation.utils.VariableSource;
import org.jetlinks.community.utils.ConverterUtils;
import org.jetlinks.core.config.ConfigKey;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class EmailTemplate
extends AbstractTemplate<EmailTemplate> {
    private static final String SEND_TO_KEY = "sendTo";
    private String subject;
    private String text;
    private List<Attachment> attachments;
    private List<String> sendTo;

    public Mono<List<String>> getSendTo(Map<String, Object> context) {
        return VariableSource.resolveValue((String)SEND_TO_KEY, context, (ConfigKey)RelationConstants.UserProperty.email).flatMapIterable(e -> ConverterUtils.convertToList((Object)e, String::valueOf)).concatWith((Publisher)Mono.justOrEmpty(this.sendTo).flatMapIterable(Function.identity())).collectList();
    }

    @Nonnull
    protected List<VariableDefinition> getEmbeddedVariables() {
        List<Attachment> attachments;
        ArrayList<VariableDefinition> variables = new ArrayList<VariableDefinition>();
        if (CollectionUtils.isEmpty(this.sendTo)) {
            variables.add(VariableDefinition.builder().id(SEND_TO_KEY).name("\u6536\u4ef6\u4eba").expand("businessType", (Object)"user").required(true).type("array").build());
        }
        if (!CollectionUtils.isEmpty(attachments = this.getAttachments())) {
            int index = 0;
            for (Attachment attachment : attachments) {
                ++index;
                if (StringUtils.isNotEmpty((CharSequence)attachment.getName()) && StringUtils.isEmpty((CharSequence)attachment.getLocation())) continue;
                variables.add(VariableDefinition.builder().id(Attachment.locationKey(index)).name(attachment.getName()).type("file").description(attachment.getName()).format("any").required(true).build());
            }
        }
        return variables;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getText() {
        return this.text;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public List<String> getSendTo() {
        return this.sendTo;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void setSendTo(List<String> sendTo) {
        this.sendTo = sendTo;
    }

    public static class Attachment {
        public static final String LOCATION_KEY = "location";
        private String name;
        private String location;

        public static String locationKey(int index) {
            return "_attach_location_" + index;
        }

        public String getName() {
            return this.name;
        }

        public String getLocation() {
            return this.location;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public Attachment(String name, String location) {
            this.name = name;
            this.location = location;
        }

        public Attachment() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attachment)) {
                return false;
            }
            Attachment other = (Attachment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Attachment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

