/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.validator.ValidatorUtils;
import org.jetlinks.community.notify.template.Template;
import org.jetlinks.community.notify.template.TemplateProperties;
import org.jetlinks.community.notify.template.VariableDefinition;

public abstract class AbstractTemplate<Self extends AbstractTemplate<Self>>
implements Template {
    private Map<String, VariableDefinition> variables;
    private String configId;

    public Self with(TemplateProperties properties) {
        if (this.variables == null) {
            this.variables = new LinkedHashMap<String, VariableDefinition>();
        }
        FastBeanCopier.copy(properties.getTemplate(), (Object)this, (String[])new String[0]);
        this.configId = properties.getConfigId();
        for (VariableDefinition variable : this.getEmbeddedVariables()) {
            this.variables.put(variable.getId(), variable);
        }
        if (null != properties.getVariableDefinitions()) {
            for (VariableDefinition embeddedVariable : properties.getVariableDefinitions()) {
                this.variables.put(embeddedVariable.getId(), embeddedVariable);
            }
        }
        return this.toSelf();
    }

    protected Self toSelf() {
        return (Self)this;
    }

    protected void addVariable(String key, String name, String ... descriptions) {
        this.addVariable(VariableDefinition.builder().id(key).name(name).description(String.join((CharSequence)"", descriptions)).build());
    }

    protected synchronized void addVariable(VariableDefinition def) {
        if (null == this.variables) {
            this.variables = new HashMap<String, VariableDefinition>();
        }
        this.variables.put(def.getId(), def);
    }

    @Override
    public final Optional<VariableDefinition> getVariable(String key) {
        return Optional.ofNullable(this.getVariables().get(key));
    }

    @Override
    @Nonnull
    public final Map<String, VariableDefinition> getVariables() {
        return this.variables == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.variables);
    }

    @Nonnull
    protected List<VariableDefinition> getEmbeddedVariables() {
        return Collections.emptyList();
    }

    public Self validate() {
        ValidatorUtils.tryValidate((Object)this, (Class[])new Class[0]);
        return this.toSelf();
    }

    public Map<String, Object> toMap() {
        return (JSONObject)JSON.toJSON((Object)this);
    }

    public String getConfigId() {
        return this.configId;
    }
}

