/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.rule;

import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.notify.NotifierManager;
import org.jetlinks.community.notify.rule.RuleNotifierProperties;
import org.jetlinks.core.Values;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.jetlinks.rule.engine.api.task.TaskExecutor;
import org.jetlinks.rule.engine.api.task.TaskExecutorProvider;
import org.jetlinks.rule.engine.defaults.FunctionTaskExecutor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class NotifierTaskExecutorProvider
implements TaskExecutorProvider {
    private final NotifierManager notifierManager;

    public String getExecutor() {
        return "notifier";
    }

    public Mono<TaskExecutor> createTask(ExecutionContext context) {
        return Mono.just((Object)((Object)new NotifierTaskExecutor(context)));
    }

    public NotifierTaskExecutorProvider(NotifierManager notifierManager) {
        this.notifierManager = notifierManager;
    }

    class NotifierTaskExecutor
    extends FunctionTaskExecutor {
        private RuleNotifierProperties properties;

        public NotifierTaskExecutor(ExecutionContext context) {
            super("\u6d88\u606f\u901a\u77e5", context);
            this.properties = this.createProperties();
        }

        protected Publisher<RuleData> apply(RuleData input) {
            return NotifierTaskExecutorProvider.this.notifierManager.getNotifier(this.properties.getNotifyType(), this.properties.getNotifierId()).switchIfEmpty(Mono.fromRunnable(() -> this.context.getLogger().warn("\u901a\u77e5\u914d\u7f6e[{}-{}]\u4e0d\u5b58\u5728", new Object[]{this.properties.getNotifyType(), this.properties.getNotifierId()}))).flatMap(notifier -> notifier.send(this.properties.getTemplateId(), Values.of(this.properties.createVariables(input)))).doOnError(err -> this.context.getLogger().error("\u53d1\u9001[{}]\u901a\u77e5[{}-{}]\u5931\u8d25", new Object[]{this.properties.getNotifyType().getName(), this.properties.getNotifierId(), this.properties.getTemplateId(), err})).doOnSuccess(ignore -> this.context.getLogger().info("\u53d1\u9001[{}]\u901a\u77e5[{}-{}]\u5b8c\u6210", new Object[]{this.properties.getNotifyType().getName(), this.properties.getNotifierId(), this.properties.getTemplateId()})).thenReturn((Object)this.context.newRuleData((Object)input));
        }

        public void reload() {
            this.properties = this.createProperties();
        }

        RuleNotifierProperties createProperties() {
            RuleNotifierProperties properties = (RuleNotifierProperties)FastBeanCopier.copy((Object)this.context.getJob().getConfiguration(), RuleNotifierProperties.class, (String[])new String[0]);
            properties.initVariable();
            properties.validate();
            return properties;
        }
    }
}

