/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.event;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hswebframework.utils.StringUtils;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.event.SerializableNotifierEvent;
import org.jetlinks.community.notify.template.Template;

public class NotifierEvent {
    private boolean success;
    @Nullable
    private Throwable cause;
    @Nonnull
    private String notifierId;
    @Nonnull
    private NotifyType notifyType;
    @Nonnull
    private Provider provider;
    @Nullable
    private String templateId;
    @Nullable
    private Template template;
    @Nonnull
    private Map<String, Object> context;

    public SerializableNotifierEvent toSerializable() {
        return SerializableNotifierEvent.builder().success(this.success).notifierId(this.notifierId).notifyType(this.notifyType.getId()).provider(this.provider.getId()).templateId(this.templateId).template(this.template).context(this.context).cause(this.cause != null ? StringUtils.throwable2String((Throwable)this.cause) : "").errorType(this.cause != null ? this.cause.getClass().getName() : null).build();
    }

    NotifierEvent(boolean success, @Nullable Throwable cause, @Nonnull String notifierId, @Nonnull NotifyType notifyType, @Nonnull Provider provider, @Nullable String templateId, @Nullable Template template, @Nonnull Map<String, Object> context) {
        if (notifierId == null) {
            throw new NullPointerException("notifierId is marked non-null but is null");
        }
        if (notifyType == null) {
            throw new NullPointerException("notifyType is marked non-null but is null");
        }
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.success = success;
        this.cause = cause;
        this.notifierId = notifierId;
        this.notifyType = notifyType;
        this.provider = provider;
        this.templateId = templateId;
        this.template = template;
        this.context = context;
    }

    public static NotifierEventBuilder builder() {
        return new NotifierEventBuilder();
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nullable
    public Throwable getCause() {
        return this.cause;
    }

    @Nonnull
    public String getNotifierId() {
        return this.notifierId;
    }

    @Nonnull
    public NotifyType getNotifyType() {
        return this.notifyType;
    }

    @Nonnull
    public Provider getProvider() {
        return this.provider;
    }

    @Nullable
    public String getTemplateId() {
        return this.templateId;
    }

    @Nullable
    public Template getTemplate() {
        return this.template;
    }

    @Nonnull
    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setCause(@Nullable Throwable cause) {
        this.cause = cause;
    }

    public void setNotifierId(@Nonnull String notifierId) {
        if (notifierId == null) {
            throw new NullPointerException("notifierId is marked non-null but is null");
        }
        this.notifierId = notifierId;
    }

    public void setNotifyType(@Nonnull NotifyType notifyType) {
        if (notifyType == null) {
            throw new NullPointerException("notifyType is marked non-null but is null");
        }
        this.notifyType = notifyType;
    }

    public void setProvider(@Nonnull Provider provider) {
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        this.provider = provider;
    }

    public void setTemplateId(@Nullable String templateId) {
        this.templateId = templateId;
    }

    public void setTemplate(@Nullable Template template) {
        this.template = template;
    }

    public void setContext(@Nonnull Map<String, Object> context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.context = context;
    }

    public static class NotifierEventBuilder {
        private boolean success;
        private Throwable cause;
        private String notifierId;
        private NotifyType notifyType;
        private Provider provider;
        private String templateId;
        private Template template;
        private Map<String, Object> context;

        NotifierEventBuilder() {
        }

        public NotifierEventBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        public NotifierEventBuilder cause(@Nullable Throwable cause) {
            this.cause = cause;
            return this;
        }

        public NotifierEventBuilder notifierId(@Nonnull String notifierId) {
            this.notifierId = notifierId;
            return this;
        }

        public NotifierEventBuilder notifyType(@Nonnull NotifyType notifyType) {
            this.notifyType = notifyType;
            return this;
        }

        public NotifierEventBuilder provider(@Nonnull Provider provider) {
            this.provider = provider;
            return this;
        }

        public NotifierEventBuilder templateId(@Nullable String templateId) {
            this.templateId = templateId;
            return this;
        }

        public NotifierEventBuilder template(@Nullable Template template) {
            this.template = template;
            return this;
        }

        public NotifierEventBuilder context(@Nonnull Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public NotifierEvent build() {
            return new NotifierEvent(this.success, this.cause, this.notifierId, this.notifyType, this.provider, this.templateId, this.template, this.context);
        }

        public String toString() {
            return "NotifierEvent.NotifierEventBuilder(success=" + this.success + ", cause=" + this.cause + ", notifierId=" + this.notifierId + ", notifyType=" + this.notifyType + ", provider=" + this.provider + ", templateId=" + this.templateId + ", template=" + this.template + ", context=" + this.context + ")";
        }
    }
}

