/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.configuration;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.template.Template;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.notify.template.TemplateProperties;
import reactor.core.publisher.Mono;

public class CompositeTemplateManager
implements TemplateManager {
    private final List<TemplateManager> managers;

    private <T> Mono<T> doWith(Function<TemplateManager, Mono<T>> executor) {
        Mono mono = null;
        for (TemplateManager manager : this.managers) {
            if (mono == null) {
                mono = executor.apply(manager);
                continue;
            }
            mono = mono.switchIfEmpty(executor.apply(manager));
        }
        return mono == null ? Mono.empty() : mono;
    }

    @Override
    @Nonnull
    public Mono<? extends Template> getTemplate(@Nonnull NotifyType type, @Nonnull String id) {
        return this.doWith(manager -> manager.getTemplate(type, id).onErrorResume(UnsupportedOperationException.class, err -> Mono.empty())).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u901a\u77e5\u7c7b\u578b\u4e0d\u652f\u6301:" + type.getId())));
    }

    @Override
    @Nonnull
    public Mono<? extends Template> createTemplate(@Nonnull NotifyType type, @Nonnull TemplateProperties properties) {
        return this.doWith(manager -> manager.createTemplate(type, properties).onErrorResume(UnsupportedOperationException.class, err -> Mono.empty())).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u901a\u77e5\u7c7b\u578b\u4e0d\u652f\u6301:" + type.getId())));
    }

    @Override
    @Nonnull
    public Mono<Void> reload(String templateId) {
        return this.doWith(manager -> manager.reload(templateId));
    }

    public CompositeTemplateManager(List<TemplateManager> managers) {
        this.managers = managers;
    }
}

