/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.template;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hswebframework.web.utils.TemplateParser;
import org.jetlinks.community.notify.template.VariableDefinition;
import org.jetlinks.community.relation.utils.VariableSource;
import org.jsoup.Jsoup;

public class TemplateUtils {
    public static Set<String> getVariables(String templateText) {
        return TemplateUtils.getVariables(templateText, "${", "}");
    }

    public static Set<String> getVariables(String templateText, String suffix, String prefix) {
        LinkedHashSet<String> variable = new LinkedHashSet<String>();
        TemplateParser parser = new TemplateParser();
        parser.setTemplate(templateText);
        parser.setPrepareStartSymbol(suffix.toCharArray());
        parser.setPrepareEndSymbol(prefix.toCharArray());
        parser.parse(varName -> {
            if (varName.contains("<")) {
                varName = Jsoup.parse((String)varName).text();
            }
            variable.add((String)varName);
            return "";
        });
        return variable;
    }

    public static String simpleRender(String templateText, Map<String, Object> context) {
        return TemplateUtils.simpleRender(templateText, context, var -> null);
    }

    public static String simpleRender(String templateText, Map<String, Object> context, Function<String, VariableDefinition> variables) {
        return TemplateParser.parse((String)templateText, varName -> {
            if (varName.contains("<")) {
                varName = Jsoup.parse((String)varName).text();
            }
            VariableDefinition def = (VariableDefinition)variables.apply((String)varName);
            Object value = VariableSource.resolveValue((String)varName, (Map)context);
            if (def != null) {
                return def.convertValue(value);
            }
            if (null == value) {
                return "";
            }
            return String.valueOf(value);
        });
    }
}

