/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify;

import javax.annotation.Nonnull;
import org.jetlinks.community.notify.Notifier;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.event.NotifierEvent;
import org.jetlinks.community.notify.template.Template;
import org.jetlinks.core.Values;
import reactor.core.publisher.Mono;

public abstract class NotifierProxy<T extends Template>
implements Notifier<T> {
    private final Notifier<T> target;

    @Override
    public String getNotifierId() {
        return this.target.getNotifierId();
    }

    @Override
    @Nonnull
    public NotifyType getType() {
        return this.target.getType();
    }

    @Override
    @Nonnull
    public Provider getProvider() {
        return this.target.getProvider();
    }

    public <R> R unwrap(Class<R> type) {
        return (R)this.target.unwrap(type);
    }

    public boolean isWrapperFor(Class<?> type) {
        return this.target.isWrapperFor(type);
    }

    @Override
    @Nonnull
    public Mono<Void> send(@Nonnull String templateId, Values context) {
        return this.target.send(templateId, context).then(Mono.defer(() -> this.onSuccess((T)templateId, context))).onErrorResume(err -> this.onError(templateId, context, (Throwable)err).then(Mono.error((Throwable)err)));
    }

    @Override
    @Nonnull
    public Mono<Void> send(@Nonnull T template, @Nonnull Values context) {
        return this.target.send(template, context).then(Mono.defer(() -> this.onSuccess(template, context))).onErrorResume(err -> this.onError(template, context, (Throwable)err).then(Mono.error((Throwable)err)));
    }

    protected Mono<Void> onError(T template, Values ctx, Throwable error) {
        return this.onEvent(NotifierEvent.builder().cause(error).context(ctx.getAllValues()).notifierId(this.getNotifierId()).notifyType(this.getType()).provider(this.getProvider()).template((Template)template).build());
    }

    protected Mono<Void> onError(String templateId, Values ctx, Throwable error) {
        return this.onEvent(NotifierEvent.builder().cause(error).context(ctx.getAllValues()).notifierId(this.getNotifierId()).notifyType(this.getType()).provider(this.getProvider()).templateId(templateId).build());
    }

    protected Mono<Void> onSuccess(String templateId, Values ctx) {
        return this.onEvent(NotifierEvent.builder().success(true).context(ctx.getAllValues()).notifierId(this.getNotifierId()).notifyType(this.getType()).provider(this.getProvider()).templateId(templateId).build());
    }

    protected Mono<Void> onSuccess(T template, Values ctx) {
        return this.onEvent(NotifierEvent.builder().success(true).context(ctx.getAllValues()).notifierId(this.getNotifierId()).notifyType(this.getType()).provider(this.getProvider()).template((Template)template).build());
    }

    protected abstract Mono<Void> onEvent(NotifierEvent var1);

    @Override
    @Nonnull
    public Mono<Void> close() {
        return this.target.close();
    }

    public NotifierProxy(Notifier<T> target) {
        this.target = target;
    }
}

