/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.template;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.validation.constraints.NotBlank;
import org.hswebframework.utils.time.DateFormatter;
import org.hswebframework.web.exception.ValidationException;
import org.jetlinks.community.ConfigMetadataConstants;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.types.AbstractType;
import org.jetlinks.core.metadata.types.DataTypes;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.StringType;
import org.springframework.util.StringUtils;

public class VariableDefinition {
    @Schema(description="\u53d8\u91cf\u6807\u8bc6")
    @NotBlank
    private String id;
    @Schema(description="\u53d8\u91cf\u540d\u79f0")
    private String name;
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Schema(description="\u7c7b\u578b")
    private String type;
    @Schema(description="\u662f\u5426\u5fc5\u9009")
    private boolean required;
    @Schema(description="\u683c\u5f0f")
    private String format;
    @Schema(description="\u5176\u4ed6\u914d\u7f6e")
    private Map<String, Object> expands;
    @Schema(description="\u9ed8\u8ba4\u503c")
    private String defaultValue;

    public static VariableDefinitionBuilder builder() {
        return new VariableDefinitionBuilder();
    }

    public String convertValue(Object value) {
        if (value == null) {
            value = this.defaultValue;
        }
        if (this.required && value == null) {
            throw new ValidationException(this.id, "error.template_var_required", new Object[]{this.getId(), this.getName()});
        }
        DataType dataType = this.lookupType();
        String fmt = this.format;
        Object val = value;
        if (val == null) {
            return "";
        }
        if (dataType instanceof DateTimeType) {
            Date date = ((DateTimeType)dataType).convert(val);
            if ("timestamp".equals(fmt)) {
                return String.valueOf(date.getTime());
            }
            if (fmt == null) {
                fmt = "yyyy-MM-dd HH:mm:ss";
            }
            return DateFormatter.toString((Date)date, (String)fmt);
        }
        if (dataType instanceof Converter) {
            val = ((Converter)dataType).convert(val);
        }
        if (StringUtils.hasText((String)fmt) && fmt.contains("%")) {
            if (val instanceof Number) {
                val = ((Number)val).doubleValue();
            }
            return String.format(fmt, val);
        }
        return String.valueOf(val);
    }

    private DataType lookupType() {
        DataType dataType = Optional.ofNullable(DataTypes.lookup((String)this.type)).map(Supplier::get).orElse((DataType)StringType.GLOBAL);
        if (dataType instanceof AbstractType) {
            ((AbstractType)dataType).expands(this.expands);
            if (StringUtils.hasText((String)this.format)) {
                ((AbstractType)dataType).expand(ConfigMetadataConstants.format, (Object)this.format);
            }
        }
        return dataType;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getFormat() {
        return this.format;
    }

    public Map<String, Object> getExpands() {
        return this.expands;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public VariableDefinition(String id, String name, String description, String type, boolean required, String format, Map<String, Object> expands, String defaultValue) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.type = type;
        this.required = required;
        this.format = format;
        this.expands = expands;
        this.defaultValue = defaultValue;
    }

    public VariableDefinition() {
    }

    public static class VariableDefinitionBuilder {
        @NotBlank
        private String id;
        private String name;
        private String description;
        private String type;
        private boolean required;
        private String format;
        private final Map<String, Object> expands = new HashMap<String, Object>();
        private String defaultValue;

        VariableDefinitionBuilder() {
        }

        public VariableDefinitionBuilder id(@NotBlank String id) {
            this.id = id;
            return this;
        }

        public VariableDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VariableDefinitionBuilder description(String description) {
            this.description = description;
            return this;
        }

        public VariableDefinitionBuilder type(String type) {
            this.type = type;
            return this;
        }

        public VariableDefinitionBuilder type(DataType type) {
            this.type = type.getType();
            return this.expands(type.getExpands());
        }

        public VariableDefinitionBuilder required(boolean required) {
            this.required = required;
            return this;
        }

        public VariableDefinitionBuilder format(String format) {
            this.format = format;
            return this;
        }

        public VariableDefinitionBuilder expands(Map<String, Object> expands) {
            if (expands == null) {
                return this;
            }
            this.expands.putAll(expands);
            return this;
        }

        public VariableDefinitionBuilder expand(ConfigKey<String> key, Object value) {
            this.expands.put(key.getKey(), value);
            return this;
        }

        public VariableDefinitionBuilder expand(String key, Object value) {
            this.expands.put(key, value);
            return this;
        }

        public VariableDefinitionBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public VariableDefinition build() {
            return new VariableDefinition(this.id, this.name, this.description, this.type, this.required, this.format, this.expands, this.defaultValue);
        }

        public String toString() {
            return "VariableDefinition.VariableDefinitionBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", required=" + this.required + ", format=" + this.format + ", expands=" + this.expands + ", defaultValue=" + this.defaultValue + ")";
        }
    }
}

