/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.template;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jetlinks.community.notify.template.TemplateUtils;
import org.jetlinks.community.notify.template.VariableDefinition;
import org.jetlinks.community.relation.utils.VariableSource;

public interface Template
extends Serializable {
    default public Optional<VariableDefinition> getVariable(String key) {
        return Optional.ofNullable(this.getVariables().get(key));
    }

    @Nonnull
    default public Map<String, VariableDefinition> getVariables() {
        return Collections.emptyMap();
    }

    default public String get(Object value, String key, Map<String, Object> context) {
        if (value == null || value instanceof String && ((String)value).trim().equals("")) {
            value = VariableSource.resolveValue((String)key, context);
        }
        return this.convert(key, value);
    }

    default public String get(String key, Map<String, Object> context, Supplier<?> defaultValueSupplier) {
        Object value = VariableSource.resolveValue((String)key, context);
        if (value == null) {
            value = defaultValueSupplier.get();
        }
        return this.convert(key, value);
    }

    default public Map<String, Object> renderMap(Map<String, Object> context) {
        return Maps.transformValues(context, value -> VariableSource.of((Object)value).resolveStatic(context));
    }

    default public String convert(String key, Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(val -> this.convert(key, val)).collect(Collectors.joining(","));
        }
        VariableDefinition def = this.getVariable(key).orElse(null);
        if (null != def) {
            return def.convertValue(value);
        }
        return value == null ? "" : String.valueOf(value);
    }

    default public List<String> render(Collection<String> templates, Map<String, Object> context) {
        return templates.stream().map(str -> this.render((String)str, context)).collect(Collectors.toList());
    }

    default public String render(String templateText, Map<String, Object> context) {
        return TemplateUtils.simpleRender(templateText, context, var -> this.getVariable((String)var).orElse(null));
    }
}

