/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.configuration;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.template.TemplateProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="jetlinks.notify")
public class StaticNotifyProperties {
    private Map<String, List<NotifierProperties>> configs = new ConcurrentHashMap<String, List<NotifierProperties>>();
    private Map<String, List<TemplateProperties>> templates = new ConcurrentHashMap<String, List<TemplateProperties>>();

    public Optional<NotifierProperties> getNotifierProperties(NotifyType type, String id) {
        List<NotifierProperties> properties = this.configs.get(type.getId());
        if (properties == null) {
            return Optional.empty();
        }
        return properties.stream().filter(prop -> {
            prop.setType(type.getId());
            return Objects.equals(id, prop.getId());
        }).findAny();
    }

    public Optional<TemplateProperties> getTemplateProperties(NotifyType type, String id) {
        List<TemplateProperties> properties = this.templates.get(type.getId());
        if (properties == null) {
            return Optional.empty();
        }
        return properties.stream().filter(prop -> {
            prop.setType(type.getId());
            return Objects.equals(id, prop.getId());
        }).findAny();
    }

    public Map<String, List<NotifierProperties>> getConfigs() {
        return this.configs;
    }

    public Map<String, List<TemplateProperties>> getTemplates() {
        return this.templates;
    }

    public void setConfigs(Map<String, List<NotifierProperties>> configs) {
        this.configs = configs;
    }

    public void setTemplates(Map<String, List<TemplateProperties>> templates) {
        this.templates = templates;
    }

    public static class ObjectTemplateProperties
    extends TemplateProperties {
        private Map<String, Object> templateObject;

        public void setTemplateObject(Map<String, Object> templateObject) {
            this.templateObject = templateObject;
            this.setTemplate(templateObject);
        }

        public Map<String, Object> getTemplateObject() {
            return this.templateObject;
        }
    }
}

