/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.wechat.corp;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotBlank;
import org.jetlinks.community.notify.template.AbstractTemplate;
import org.jetlinks.community.notify.template.VariableDefinition;
import org.jetlinks.community.relation.utils.VariableSource;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigKey;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class WechatMessageTemplate
extends AbstractTemplate<WechatMessageTemplate> {
    public static final String TO_USER_KEY = "toUser";
    public static final String TO_PARTY_KEY = "toParty";
    public static final String TO_TAG_KEY = "toTag";
    @NotBlank(message="[agentId]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="[agentId]\u4e0d\u80fd\u4e3a\u7a7a") String agentId;
    private String toUser;
    private String toParty;
    private String toTag;
    @NotBlank(message="[message]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="[message]\u4e0d\u80fd\u4e3a\u7a7a") String message;

    public Mono<String> getToUser(Map<String, Object> context, ConfigKey<String> relationPropertyPath) {
        return VariableSource.resolveValue((String)TO_USER_KEY, context, relationPropertyPath).map(String::valueOf).collect(Collectors.joining(",")).defaultIfEmpty((Object)(this.toUser == null ? "" : this.toUser));
    }

    public String getToParty(Map<String, Object> context) {
        return this.getTo(TO_PARTY_KEY, context, this::getToParty);
    }

    public String getToTag(Map<String, Object> context) {
        return this.getTo(TO_TAG_KEY, context, this::getToTag);
    }

    private String getTo(String key, Map<String, Object> context, Supplier<Object> defaultValue) {
        String toUser = this.get(key, context, defaultValue);
        if (toUser != null) {
            return toUser.replace(',', '|');
        }
        return null;
    }

    @Nonnull
    protected List<VariableDefinition> getEmbeddedVariables() {
        if (StringUtils.hasText((String)this.toUser) || StringUtils.hasText((String)this.toParty) || StringUtils.hasText((String)this.toTag)) {
            return Collections.emptyList();
        }
        ArrayList<VariableDefinition> variables = new ArrayList<VariableDefinition>(3);
        variables.add(VariableDefinition.builder().id(TO_USER_KEY).name("\u6536\u4fe1\u4eba").expand("businessType", (Object)"user").type("string").build());
        variables.add(VariableDefinition.builder().id(TO_PARTY_KEY).expand("businessType", (Object)"org").type("string").name("\u6536\u4fe1\u4eba\u90e8\u95e8").build());
        variables.add(VariableDefinition.builder().id(TO_TAG_KEY).expand("businessType", (Object)"tag").type("string").name("\u6536\u4fe1\u4eba\u6807\u7b7e").build());
        return variables;
    }

    public Mono<BodyInserters.FormInserter<String>> createFormInserter(BodyInserters.FormInserter<String> inserter, Values context, ConfigKey<String> relationPropertyPath) {
        return this.getToUser(context.getAllValues(), relationPropertyPath).map(toUser -> {
            inserter.with("agentid", (Object)this.getAgentId()).with("msgtype", (Object)"text").with("text", (Object)this.createMessage(context));
            String toParty = this.getToParty(context.getAllValues());
            if (StringUtils.hasText((String)toUser)) {
                inserter.with("touser", toUser);
            }
            if (StringUtils.hasText((String)toParty)) {
                inserter.with("touser", (Object)toParty);
            }
            return inserter;
        });
    }

    public Mono<JSONObject> createJsonRequest(Values context, ConfigKey<String> relationPropertyPath) {
        return this.getToUser(context.getAllValues(), relationPropertyPath).map(toUser -> {
            JSONObject json = new JSONObject();
            json.put("agentid", (Object)this.getAgentId());
            json.put("msgtype", (Object)"text");
            json.put("text", Collections.singletonMap("content", this.render(this.message, context.getAllValues())));
            String toParty = this.getToParty(context.getAllValues());
            String toTag = this.getToTag(context.getAllValues());
            if (StringUtils.hasText((String)toUser)) {
                json.put("touser", toUser);
            }
            if (StringUtils.hasText((String)toParty)) {
                json.put("toparty", (Object)toParty);
            }
            if (StringUtils.hasText((String)toTag)) {
                json.put("totag", (Object)toTag);
            }
            return json;
        });
    }

    public Mono<UriComponentsBuilder> createUriParameter(UriComponentsBuilder builder, Values context, ConfigKey<String> relationPropertyPath) {
        return this.getToUser(context.getAllValues(), relationPropertyPath).map(toUser -> {
            builder.queryParam("agentid", new Object[]{this.getAgentId()}).queryParam("msgtype", new Object[]{"text"}).queryParam("text", new Object[]{this.createMessage(context)});
            String toParty = this.getToParty(context.getAllValues());
            String toTag = this.getToTag(context.getAllValues());
            if (StringUtils.hasText((String)toUser)) {
                builder.queryParam("touser", new Object[]{toUser});
            }
            if (StringUtils.hasText((String)toParty)) {
                builder.queryParam("toparty", new Object[]{toParty});
            }
            if (StringUtils.hasText((String)toTag)) {
                builder.queryParam("totag", new Object[]{toTag});
            }
            return builder;
        });
    }

    public String createMessage(Values context) {
        JSONObject json = new JSONObject();
        json.put("content", (Object)this.render(this.message, context.getAllValues()));
        return json.toJSONString();
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getToUser() {
        return this.toUser;
    }

    public String getToParty() {
        return this.toParty;
    }

    public String getToTag() {
        return this.toTag;
    }

    public String getMessage() {
        return this.message;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public void setToParty(String toParty) {
        this.toParty = toParty;
    }

    public void setToTag(String toTag) {
        this.toTag = toTag;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

