/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.template;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.template.Template;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.notify.template.TemplateProperties;
import org.jetlinks.community.notify.template.TemplateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public abstract class AbstractTemplateManager
implements TemplateManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractTemplateManager.class);
    protected final Map<String, Map<String, TemplateProvider>> providers = new ConcurrentHashMap<String, Map<String, TemplateProvider>>();
    protected final Map<String, Template> templates = new ConcurrentHashMap<String, Template>();

    protected abstract Mono<TemplateProperties> getProperties(NotifyType var1, String var2);

    protected void register(TemplateProvider provider) {
        this.providers.computeIfAbsent(provider.getType().getId(), ignore -> new ConcurrentHashMap()).put(provider.getProvider().getId(), provider);
    }

    @Override
    @Nonnull
    public Mono<? extends Template> createTemplate(@Nonnull NotifyType type, @Nonnull TemplateProperties prop) {
        return Mono.justOrEmpty(this.providers.get(type.getId())).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u901a\u77e5\u7c7b\u578b:" + prop.getType()))).flatMap(map -> Mono.justOrEmpty(map.get(prop.getProvider())).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u670d\u52a1\u5546:" + prop.getProvider()))).flatMap(provider -> provider.createTemplate(prop)));
    }

    @Override
    @Nonnull
    public Mono<? extends Template> getTemplate(@Nonnull NotifyType type, @Nonnull String id) {
        return Mono.justOrEmpty((Object)this.templates.get(id)).switchIfEmpty(Mono.defer(() -> this.getProperties(type, id).flatMap(prop -> this.createTemplate(type, (TemplateProperties)prop)).doOnNext(template -> this.templates.put(id, (Template)template)).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u901a\u77e5\u7c7b\u578b\u4e0d\u652f\u6301:" + type.getId())))));
    }

    @Override
    @Nonnull
    public Mono<Void> reload(String templateId) {
        return this.doReload(templateId).then();
    }

    private Mono<String> doReload(String templateId) {
        log.debug("reload notify template {}", (Object)templateId);
        return Mono.justOrEmpty((Object)this.templates.remove(templateId)).thenReturn((Object)templateId);
    }
}

