/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.rule;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.relation.utils.VariableSource;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.RuleDataHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RuleNotifierProperties {
    private static final Logger log = LoggerFactory.getLogger(RuleNotifierProperties.class);
    private DefaultNotifyType notifyType;
    private String notifierId;
    private String templateId;
    private Map<String, Object> variables;

    public void initVariable() {
        if (MapUtils.isNotEmpty(this.variables)) {
            for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
                VariableSource source = VariableSource.of((Object)entry.getValue());
                entry.setValue(source);
                if (source.getSource() != VariableSource.Source.upper || !Objects.equals(source.getUpperKey(), entry.getKey())) continue;
                log.warn("The upper key [{}] is the same as the parameter key,", (Object)entry.getKey());
            }
        }
    }

    public Map<String, Object> createVariables(RuleData data) {
        Map vars = RuleDataHelper.toContextMap((RuleData)data);
        if (MapUtils.isNotEmpty(this.variables)) {
            vars.putAll(VariableSource.wrap(this.variables, (Map)vars));
        }
        return vars;
    }

    public void validate() {
        Assert.notNull((Object)this.notifyType, (String)"notifyType can not be null");
        Assert.hasText((String)this.notifierId, (String)"notifierId can not be empty");
        Assert.hasText((String)this.templateId, (String)"templateId can not be empty");
    }

    public DefaultNotifyType getNotifyType() {
        return this.notifyType;
    }

    public String getNotifierId() {
        return this.notifierId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setNotifyType(DefaultNotifyType notifyType) {
        this.notifyType = notifyType;
    }

    public void setNotifierId(String notifierId) {
        this.notifierId = notifierId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }
}

